 #include "mbed.h"
 
 #define numsamples 1
 int touchSense1(void);
 int touchSense2(void);
 void readSerial();
 char touchDetect ();

 DigitalOut myled1(LED1);
 DigitalOut myled2(LED2);
 DigitalOut myled3(LED3);
 AnalogIn input1(p20);
 DigitalIn charger1(p19);
 DigitalOut ground1(p18);
 AnalogIn input2(p17);
 DigitalIn charger2(p16);
 DigitalOut ground2(p15);
 
 
 Serial pc(USBTX, USBRX); // tx, rx
 
 char *serial = new char [100];

 int main() {
 
    pc.attach (&readSerial);             //Foreground: read the serial
    
 
   while (1){                            //Background: compare the serial value and user input.
    int i=1,j=0;
    while (serial[j]!='E') {             //Print the host value;
    pc.printf ("%c", serial[j]);
    j++;
    } 
    pc.printf ("E");

   while (1) {
        pc.printf (" The next input should be :");  //Hint
        pc.printf ("%c", serial[i]);
        if (serial[i]=='E'){
            pc.printf (" MATCH ");
            pc.printf ("\r\n");
            i=1;
            break;  
        }     
        else if (serial[i]==touchDetect()){                        
           i++;
           wait (0.5);
        }   
        else{ 
            pc.printf (" TOUCH ERROR ");
            pc.printf ("\r\n");               //If the user touch both sensor, the retun value is 3, which will lead to touch error.
            break;}                         //Also, if the user mistouch the sensor, it's also a touch error.
    }  
    }      
 }
 
 void readSerial()
 {
    char b;
    int flag=1,i=0;
    b=pc.getc();
    pc.printf("%c",b);
    if (b=='S'){
        serial[0]='S';
        i++;
        while (flag){
            serial[i]=pc.getc();  
            pc.printf ("%c",serial[i]);       
            if (serial[i]=='E'){
                flag=0;} 
            else if (serial[i]=='S'){
                pc.printf (" HOST ERROR \r\n ");    //Host sent two S before E. Host error.
                break;} 
            i++;     
        }           
    }
}
 
char touchDetect ()        //Detect the user input
 {
    while (1) {
    if (touchSense1()){
           pc.printf (" T1 ");      //T1 means sensor1 is pressed
           if (touchSense2()){
               return '3';
           }
            while (touchSense1()){
                wait(0.5);}
           return '1';
    }
    else if (touchSense2()){
           pc.printf (" T0 ");
           if (touchSense1()){
                return '3';
           }
             while (touchSense2()){
                wait(0.5);}
           return '0';
           
    }    
    wait (0.05); 
    }
  }
  
 int touchSense1(void)
 {
     float sample;
     ground1 = 0;
     charger1.mode(PullUp);
     charger1.mode(PullNone);
     sample=input1.read();
     if (sample < 0.3) {
         return 1;
     } else {
         return 0;
    }
 }

 int touchSense2(void)
 {
     float sample;
     ground2 = 0;
     charger2.mode(PullUp);
     charger2.mode(PullNone);
     sample=input2.read();
     if (sample < 0.3) {
         return 1;
     } else {
         return 0;
    }
 }