#include <events/mbed_events.h>
#include <mbed.h>
#include "ble/BLE.h"
#include "keypad.h"
#include "ble/Gap.h"
#include "ble/services/UARTService.h"

#define NEED_CONSOLE_OUTPUT 1 /* Set this if you need debug messages on the console;
                               * it will have an impact on code-size and power consumption. */
#if NEED_CONSOLE_OUTPUT
#define DEBUG(STR) { if (uartServicePtr) uartServicePtr->write(STR, strlen(STR)); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

Timer timerset;
const static char     DEVICE_NAME[] = "KeyPad";
static UARTService* uartServicePtr;
Thread keyThread;
int mainData=0;
Serial pc(USBTX, USBRX); 
char pre;
static EventQueue eventQueue(/* event count */ 16 * EVENTS_EVENT_SIZE);

void keyThreadFun(){
    Keypad keypad(p19,p18,p17,p16,p25,p24,p23,p20);
    keypad.enablePullUp();
    char key;
    bool done=false;
    int data=0;
    pc.printf("Please touch a key on the keypad\n\r");
    while (1) 
    {
         key = keypad.getKey();
         if(key != KEY_RELEASED)
         {
             if(key!='*' && key!='#' && key!='(' && key!=')' && key!=']' && key!='@'){
                if(!done){
                    timerset.start();
                    data=data*10 + (key-'0');
                }
             }
             if(key==']'){
                timerset.stop();
                done=true;    
             }
             pc.printf("%c\r\n",key);
             wait(0.6);
         }
         if(timerset.read()>=60){
             mainData=data;
             data=0;    
         }
    }
    
}

void updateVal(char v){
    char data[4];
    sprintf(data, "%c",v);
    uartServicePtr->writeString(data);
    uartServicePtr->writeString("\n");     
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance().gap().startAdvertising();
}


/*void dataReadCallback( const GattReadCallbackParams *params )
{
    DEBUG("Receive\r\n");
}*/
void onDataWrittenCallback(const GattWriteCallbackParams *params) {
    if ((uartServicePtr != NULL)) {
        pre = *(params->data);
         
    }
}

void onBleInitError(BLE &ble, ble_error_t error)
{
    (void)ble;
    (void)error;
}

void periodicCallback(void)
{   
    updateVal('time');
    updateVal(pre);
    updateVal(mainData);
}



void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;
    ble_error_t error = params->error;

    if (error != BLE_ERROR_NONE) {
        onBleInitError(ble, error);
        return;
    }

    if (ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }

    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(onDataWrittenCallback);

  
    /* Setup primary service. */
    uartServicePtr = new UARTService(ble);
    

    /* Setup advertising. */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::SHORTENED_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));

    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_128BIT_SERVICE_IDS, (uint8_t *)UARTServiceUUID_reversed, sizeof(UARTServiceUUID_reversed));

    ble.gap().setAdvertisingInterval(100); /* 100ms */
    ble.gap().startAdvertising();
}

void scheduleBleEventsProcessing(BLE::OnEventsToProcessCallbackContext* context) {
    BLE &ble = BLE::Instance();
    eventQueue.call(Callback<void()>(&ble, &BLE::processEvents));
}

int main()
{
    Ticker ticker;
    ticker.attach(periodicCallback,900);
    BLE &ble = BLE::Instance();
    ble.onEventsToProcess(scheduleBleEventsProcessing);
    ble.init(bleInitComplete);
    keyThread.start(keyThreadFun);
    eventQueue.dispatch_forever();
    return 0;
}



