#include "mbed.h"
#include "WiflyInterface.h"
#include "Websocket.h"
#include "MMA7660FC.h"
 

/* wifly interface:
*     - p9 and p10 are for the serial communication
*     - p19 is for the reset pin
*     - p26 is for the connection status
*     - "mbed" is the ssid of the network
*     - "password" is the password
*     - WPA is the security
*/
WiflyInterface wifly(p9, p10, p19, p26, "Nexus_5", "1234567890", WPA);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
 
#define ADDR_MMA7660 0x98                   // I2C SLAVE ADDR MMA7660FC

MMA7660FC Acc(p28, p27, ADDR_MMA7660);      //sda, scl, Addr
Serial pc(USBTX, USBRX);


float G_VALUE[64] = {0, 0.047, 0.094, 0.141, 0.188, 0.234, 0.281, 0.328, 0.375, 0.422, 0.469, 0.516, 0.563, 0.609, 0.656, 0.703, 0.750, 0.797, 0.844, 0.891, 0.938, 0.984, 1.031, 1.078, 1.125, 1.172, 1.219, 1.266, 1.313, 1.359, 1.406, 1.453, -1.500, -1.453, -1.406, -1.359, -1.313, -1.266, -1.219, -1.172, -1.125, -1.078, -1.031, -0.984, -0.938, -0.891, -0.844, -0.797, -0.750, -0.703, -0.656, -0.609, -0.563, -0.516, -0.469, -0.422, -0.375, -0.328, -0.281, -0.234, -0.188, -0.141, -0.094, -0.047};

int main() {
    wifly.init(); //Use DHCP
    //wifly.init("192.168.21.33","255.255.255.0","192.168.21.2");
    while (!wifly.connect());
    myled1 = 1;
    printf("IP Address is %s\n\r", wifly.getIPAddress());

    //Websocket ws("ws://192.168.0.153:8080/ws/accel/send");
    //Websocket ws("ws://192.168.0.102:8888");
    Websocket ws("ws://wot.city/object/accelerometer/send");
    
    while (!ws.connect());
    myled2 = 1;
 
    Acc.init();                                                     // Initialization
    pc.printf("Value reg 0x06: %#x\n", Acc.read_reg( 0x06));         // Test the correct value of the register 0x06
    pc.printf("Value reg 0x08: %#x\n", Acc.read_reg(0x08));         // Test the correct value of the register 0x08
    pc.printf("Value reg 0x07: %#x\n\r", Acc.read_reg(0x07));       // Test the correct value of the register 0x07
           
    while (1) {
        char data[256];
       
        myled3 = 1;
        float x=0, y=0, z=0;
        float ax=0, ay=0, az=0;
        
        Acc.read_Tilt(&x, &y, &z);                                  // Read the acceleration                    
        pc.printf("Tilt x: %2.2f degree \n", x);                    // Print the tilt orientation of the X axis
        pc.printf("Tilt y: %2.2f degree \n", y);                    // Print the tilt orientation of the Y axis
        pc.printf("Tilt z: %2.2f degree \n", z);                    // Print the tilt orientation of the Z axis

        wait_ms(100);

        ax = G_VALUE[Acc.read_x()];
        ay = G_VALUE[Acc.read_y()];
        az = G_VALUE[Acc.read_z()];
        
//        if(ax<0){
//            myled1=1;
//        }else{
//            myled1=0; 
//        }
//        if(ay<0){
//            myled2=1;
//        }else{
//            myled2=0; 
//        }
//        if(az<0){
//            myled3=1;
//        }else{
//            myled3=0; 
//        }
        
        wait(0.2);
        sprintf(data , "{\"ax\": %f, \"ay\": %f, \"az\": %f}", ax, ay, az);
        ws.send(data);
        
        //wait(1.0);
    }
}
