#include "mbed.h"
#include "TransmitterIR.h"

DigitalOut lpc1768_led_1(LED1);
DigitalOut grove_button(p20);

TransmitterIR ir_tx(p21);

int main() {
    lpc1768_led_1 = 0;
    while(1) {
        if (grove_button) {
            lpc1768_led_1 = 1;
            
            RemoteIR::Format format = RemoteIR::SONY;
            uint8_t buf[] = { 0x80, 0x00 };
            int bitcount = 12;
            if (ir_tx.getState() == TransmitterIR::Idle) {
                bitcount = ir_tx.setData(format, buf, bitcount);
            }               
        }
        lpc1768_led_1 = 0;
    }
}
