/*
  main.cpp
  2014 Copyright (c) Seeed Technology Inc.  All right reserved.

  Author:lawliet zou(lawliet.zou@gmail.com)
  2014-02-17

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "mbed.h"
#include "SeeedStudioTFTv2.h"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "car.h"
#include "DFRobot_LIS2DH12.h"

#define PIN_XP          p20
#define PIN_XM          p19
#define PIN_YP          p18
#define PIN_YM          p17
#define PIN_MOSI        p11
#define PIN_MISO        p12
#define PIN_SCLK        p13
#define PIN_CS_TFT      p14
#define PIN_DC_TFT      p21
#define PIN_BL_TFT      p15
//#define PIN_CS_SD       D4

SeeedStudioTFTv2 TFT(PIN_XP, PIN_XM, PIN_YP, PIN_YM, PIN_MOSI, PIN_MISO, PIN_SCLK, PIN_CS_TFT, PIN_DC_TFT, PIN_BL_TFT);

// Serial connection between PC and MBED
Serial pc(USBTX, USBRX);
I2C i2c(p9, p10);
DFRobot_LIS2DH12 LIS(&i2c,&pc); 

point p;    // creates pointer p.x,p.y


// sub-program
// this program will wait until user touches screen
// analog data of touch panel is converted trough ADC to digital value 
// getTouch will store that value
//getPixel will then convert ADC value to 320*240 pixel coordinates
// this touch program will be used in every code at this example

void touch()
 {
    while(1)
     {
         p.x=0;p.y=0;
         if (TFT.getTouch(p)==TFT.YES) // read analog pos. 
         {  
            TFT.getTouch(p);
            TFT.getPixel(p);             // convert to pixel pos 
            pc.printf("\n\r Point x:%d, y:%d", p.x, p.y); // will print p.x and p.y valu to pc(putty/teraterm)
            wait_ms(150);   // give some time for the touch
            break;
        }
     }
 }

void DFRobot_LIS2DH12::getIncline(int16_t &a, int16_t &b, int16_t &c) 
{   
    if((c > 900) && (c < 1100)&&(a > -250) && (a < 250)&&(b > -250) && (b < 250))
    {
                TFT.printf("The sensor is level.");
    }
    else
    {
        TFT.printf("The sensor is tilted ");
        if(a > 250)
        {
            TFT.printf("left");
            if(b > 250)
            {
                TFT.printf(" and backward.");
            }
            else if(b < -250)
            {
                TFT.printf(" and forward.");
            }
            else
            {
                TFT.printf(".");
            }
        }
        else if(a < -250)
        {
            TFT.printf("right");
            if(b > 250)
            {
                TFT.printf(" and backward.");
            }
            else if(b < -250)
            {
                TFT.printf(" and forward.");
            }
            else
            {
                TFT.printf(".");
            }
        }
        else
        {
            if(b > 250)
            {
                TFT.printf("backward.");
            }
            else if(b < -250)
            {
                TFT.printf("forward.");
            }
            else
            {
                TFT.printf("upside down.");
            }
        }
    }
    TFT.printf("\n\r");
}

int main()
{
    while(1)
    {
        
    TFT.locate(0,0); // Set pixel location at screen
    int counter=0;
    //TFT initialize
    TFT.claim(stdout);      // send stdout to the TFT display
    TFT.set_orientation(0); // set screen orientation to vertical
    // TFT.set_orientation(1); // set screen orientation to horizontal
    TFT.background(Black);    // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen 
    TFT.set_font((unsigned char*) Arial12x12);     // set used txt font
   
     while(LIS.init(LIS2DH12_RANGE_8GA) != 0)
    {
    TFT.printf("No I2C devices found\n\r");
    wait(1);
    } 
         int16_t a, b, c;
         
     while (counter<12)
    {
        LIS.readXYZ(a, b, c);
        LIS.mgScale(a, b, c);
        LIS.getIncline(a,b,c);  
        wait(2); // wait 2 seconds  
        counter++;
    }
  }
}
