#include "mbed.h"
#include"time.h"
#include"math.h"

#define UPA1 10000//坐时最大加速度值
#define UPA2 10000
#define UPA3 10000
uint16_t x_a,y_a,z_a,all_a;
bool flag = 0;

SPI spi_master(P0_6,P0_5,P0_7); //mosi miso sclk 
DigitalOut cs(P0_4);

//Serial pc(P0_23,P0_25);

Serial pc(P0_9,P0_11);

PwmOut buzzer(p22);//buzzer
float frequency[]={659,554,659,554,440,494,554,587,494,659,554,440};
float beat[]={1,1,1,1,1,0.5,0.5,1,1,1,1,2}; //节拍数组

uint8_t LIS3DH_SPI_RD(uint8_t addr)
{
    uint8_t  temp;
    cs = 0;
    wait_us(10);
    spi_master.write(addr);      
    temp=spi_master.write(0xff);
    wait_us(10);
    cs = 1;
    return temp;
}

void LIS3DH_SPI_WR(uint8_t addr,uint8_t wrdata)
{  
    cs = 0;
    wait_us(10);
    spi_master.write(addr);
    spi_master.write(wrdata);
    wait_us(10);
    cs = 1;
}

void SPI_LIS3DH_Init()//启动函数
{
   spi_master.format(8,3);
   spi_master.frequency(100000);
   wait_ms(5);
   LIS3DH_SPI_WR(0x24,0x80);
   wait_ms(5);
   LIS3DH_SPI_WR(0x20,0x17);
   LIS3DH_SPI_WR(0x23,0x80);
}

void get_val(void)//得到加速度函数
{
    uint8_t Dx_L=1,Dy_L=1,Dz_L=1;
    uint8_t Dx_H=1,Dy_H=1,Dz_H=1;
    if(LIS3DH_SPI_RD(0x0f|0x80)==0x33)
    {
         printf("check device ok!\r\n");
         flag=1;
         Dx_H=LIS3DH_SPI_RD(0x29|0x80);   
         Dx_L=LIS3DH_SPI_RD(0x28|0x80);
         Dy_H=LIS3DH_SPI_RD(0x2b|0x80);
         Dy_L=LIS3DH_SPI_RD(0x2A|0x80);
         Dz_H=LIS3DH_SPI_RD(0x2d|0x80);
         Dz_L=LIS3DH_SPI_RD(0x2C|0x80);  
    }
    else
    { 
        printf("check device err!\r\n");
        wait(1);
    }
    x_a=Dx_H<<8|Dx_L/16;
    y_a=Dy_H<<8|Dy_L/16;
    z_a=Dz_H<<8|Dz_L/16;
}
void buzzerini(void)
{  while(1){
   for (int i=0;i<=11;i++) 
   {
       buzzer.period(1/(2*frequency[i])); // 设置PWM周期
       buzzer=0.5; // 设置占空比
       wait(0.4*beat[i]); // 保持节拍周期
    }
    get_val();
    if(x_a>UPA3)
      {
         buzzer.period_us(0);
         break;
       }
}
}
void calsample(void)
{  uint16_t sum;
   clock_t st,en;
   st=clock();
   get_val();
   while((double)((en=clock())-st)/CLK_TCK>100)
   {  
      all_a=(uint16_t)sqrt((double)(x_a+y_a+z_a));
      get_val();
      sum+=all_a;
      wait(10);
      }
}
void sit_judgement()
{   int flag=1;
    clock_t start,end;
    start=clock();
    calsample();
    while(all_a<=UPA1)//T+的情况
    {   end=clock();
        if((double)(end-start)/CLK_TCK>300)//坐了300s
        {   flag=0;
            buzzerini();
            break;
            }
        calsample();
    }
    while(flag)//T-的情况
    {  calsample();
       if(all_a<UPA2)
       {
           break;
           }
        wait(10);
    }
}
      
   
int main(void)
{
  SPI_LIS3DH_Init();
  while(1)
  {  
     sit_judgement();
     if(flag)
     {   
         flag=0;
         wait(5);//等站起来后读取判断周期变长
     }
  }
}