/*

Primero se descarga el driver: https://developer.mbed.org/handbook/Windows-serial-configuration
Se instala mientras la mbed está contectada a la pc

Conexiones:
    Utilizando el acelerometro ADXL335:

    Vout - Vcc
    p18 - Z_Out
    p19 - Y_Out
    p20 - X_Out
    GND - GND
*/

#include "mbed.h"
 
AnalogIn dataX(p20);                                //Se definen la entradas analógicas
AnalogIn dataY(p19);
AnalogIn dataZ(p18);
Serial serial(USBTX,USBRX);                         //Se crea un objeto Serial para la comunicación serial.
 
int main() {
    serial.baud(9600);                              //Se define un baudrate de 9600.
    float x,y,z;                                    //Variables para los datos recibidos y modificados.
    
    while(1)
    {  
        x = (dataX - 0.495) * 98.07;
        y = (dataY - 0.495) * 98.07;
        z = (dataZ - 0.495) * 98.07;
        serial.printf("i,%f,%f,%f\n",x,y,z); 
    }   
}
