#include "radio.h"

//InterruptIn txByte[8]={InterruptIn(D2),InterruptIn(D3),InterruptIn(D4),InterruptIn(D5),InterruptIn(D7),InterruptIn(D8),InterruptIn(D9),InterruptIn(D14)};
InterruptIn txByte0(PB_1, PullDown);//D2,A1,PC_8 didn't work, PC_5
InterruptIn txByte1(PB_15, PullDown);//D3 didn't work, A2 works
InterruptIn txByte2(D4, PullDown);
InterruptIn txByte3(D7, PullDown);
InterruptIn txByte4(D5, PullDown);
InterruptIn txByte5(PB_14, PullDown);//D8 didn't work, a3 works
InterruptIn txByte6(D9, PullDown);//D9 didn't work, a4 works
InterruptIn txByte7(PB_2, PullDown);//D14,PC_0(A6),PC_6 didn't work
EventQueue queue(10 * EVENTS_EVENT_SIZE);
Thread t;
Radio loRaRadio;

uint8_t ID_byte = 42;

void transmit( uint8_t byte);

//uint8_t old_byte = 0;
void tx_event(void)
{
    printf("tx_event\n\r");
    uint8_t byte = 0;

    uint8_t bit0 = txByte0.read();
    uint8_t bit1 = txByte1.read() << 1;
    uint8_t bit2 = txByte2.read() << 2;
    uint8_t bit3 = txByte3.read() << 3;
    uint8_t bit4 = txByte4.read() << 4;
    uint8_t bit5 = txByte5.read() << 5;
    uint8_t bit6 = txByte6.read() << 6;
    uint8_t bit7 = txByte7.read() << 7;
    if(bit0 || bit1 || bit2 || bit3 || bit4 || bit5 || bit6 || bit7)
    {
        byte = bit0 + bit1 + bit2 + bit3 + bit4 + bit5 + bit6 + bit7;
        transmit(byte);
    }
    printf("bit0 :%d,\n\r",bit0);
    printf("bit1 :%d,\n\r",bit1);
    printf("bit2 :%d,\n\r",bit2);
    printf("bit3 :%d,\n\r",bit3);
    printf("bit4 :%d,\n\r",bit4);
    printf("bit5 :%d,\n\r",bit5);
    printf("bit6 :%d,\n\r",bit6);
    printf("bit7 :%d,\n\r",bit7);
}

void rise_handler(void) {
    //printf("rise_handler in context %p\r\n", Thread::gettid());
    queue.call(tx_event);

}

// Semtech radio definitions for SX127x, SX126x and SX128x

#if defined(SX127x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    11
    #define CF_HZ               912000000
    #define TX_DBM              00
#elif defined(SX126x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    10
    #define CF_HZ               915000000
    #define TX_DBM              (Radio::chipType == CHIP_TYPE_SX1262 ? 20 : 14) 
#elif defined(SX128x_H)
    #define BW_KHZ              200
    #define SPREADING_FACTOR    7
    #define CF_HZ               2487000000
    #define TX_DBM              6
#endif

/******************** Setup radio transmitter ****************************/


volatile bool txDone;

void txDoneCB()
{
    txDone = true;
}

void rxDoneCB(uint8_t size, float rssi, float snr)
{
}

    // Define radio events for transmitter

const RadioEvents_t rev = {
    /* Dio0_top_half */     NULL,
    /* TxDone_topHalf */    NULL,
    /* TxDone_botHalf */    txDoneCB,
    /* TxTimeout  */        NULL,
    /* RxDone  */           rxDoneCB,
    /* RxTimeout  */        NULL,
    /* RxError  */          NULL,
    /* FhssChangeChannel  */NULL,
    /* CadDone  */          NULL
};

int main()
{
        // Start the event queue
    t.start(callback(&queue, &EventQueue::dispatch_forever));

    // The 'rise' handler will execute in the context of thread 't'
    // for(int i = 0; i < 8; i++)
    // {
    //     txByte[i].rise(queue.event(rise_handler));
    // }
    txByte0.rise(rise_handler);
    txByte1.rise(rise_handler);
    txByte2.rise(rise_handler);
    txByte3.rise(rise_handler);
    txByte4.rise(rise_handler);
    txByte5.rise(rise_handler);
    txByte6.rise(rise_handler);
    txByte7.rise(rise_handler);


    uint8_t seq = 0;  //  Set initial transmit sequence to 0
 
    printf("\r\nreset-tx ");
    
    // Start radio transmitter after POR or reset

    loRaRadio.Init(&rev);

    //Set radio properties for transmitter

    loRaRadio.Standby();
    loRaRadio.LoRaModemConfig(BW_KHZ, SPREADING_FACTOR, 1);
    loRaRadio.SetChannel(CF_HZ);

    // Set transmitter output power

    loRaRadio.set_tx_dbm(TX_DBM);

    // Setup transmit packet payload  -> preambleLen, fixLen, crcOn, invIQ
               
    loRaRadio.LoRaPacketConfig(8, false, true, false);
    
    printf("\n");
    
    printf("%02d \r\n\n", seq);

    for (;;) {}

        // loRaRadio.radio.tx_buf[0] = seq;  // set payload 
        // txDone = false;
        // loRaRadio.Send(10, 0, 0, 0);   // begin transmission of payload 

        // while (!txDone) {
        //     loRaRadio.service();
        // }

        // // Transmit payload every 500mS

        // wait(0.5);  // throttle sending rate 
        // seq++;  // change payload (increment sequence number)
        // printf("%02d \r\n\n", seq);  // Print sequence number
        
        //}
}

void transmit( uint8_t byte)
{
        //volatile bool tx_Done;
        loRaRadio.radio.tx_buf[0] = ID_byte;  // set payload 
        loRaRadio.radio.tx_buf[1] = byte;  // set payload 
        txDone = false;
        loRaRadio.Send(2, 0, 0, 0);   // begin transmission of payload 

        while (!txDone) {
            loRaRadio.service();
        }
        printf("transmission complete\n\r");
}
