#include "radio.h"
#define MASK_XXXXXXX_ 15
// Semtech radio definitions for SX127x, SX126x and SX128x

#if defined(SX127x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    11
    #define CF_HZ               912000000
#elif defined(SX126x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    10
    #define CF_HZ               913000000
#elif defined(SX128x_H)
    #define BW_KHZ              200
    #define SPREADING_FACTOR    7
    #define CF_HZ               2487000000
#endif

DigitalOut myled(LED1);
DigitalOut signalPin[8] = {PB_1,PB_15,D4,D7,D5,PB_14,D9,D14};
DigitalOut syncPin(PC_4);
Timeout resetTrip;

/**********************************************************************/

void txDoneCB()
{
}

void turnOffSyncPin() {
    syncPin = 0;
}

void rxDoneCB(uint8_t size, float rssi, float snr)
{
    unsigned i;
    printf("%.1fdBm  snr:%.1fdB\t", rssi, snr);
    uint8_t maxShift = 7;

    myled.write(!myled.read()); // toggle LED

    //write first received byte as state of pins
    uint8_t byte = Radio::radio.rx_buf[0];
    uint8_t tempByte = byte;
    uint8_t bit[8] = {0};
    for (int i = 0; i<8; i++)
    {
        tempByte = tempByte << (maxShift - i);
        tempByte = tempByte >> (maxShift);
        tempByte = tempByte << i;
        if(tempByte)bit[i] = 1;
        else bit[i] = 0;
        tempByte = byte;
    }
    printf("\n\r");
    printf("byte: %d",byte);
    for (int i = 0; i<8; i++)
    {
    printf("bit%d: %d\n\r",i,bit[i]);
    }

    for (int i = 0; i<8; i++)
    {
        signalPin[i] = bit[i];
    }
    if(bit[0])
    {
        syncPin = 1;
        resetTrip.attach(&turnOffSyncPin, .01);
    }
    ThisThread::sleep_for(200);
    
    for (int i = 0; i<8; i++)
    {
        signalPin[i] = 0;
    }
    

    // Display payload packet information

    for (i = 0; i < size; i++) {
        printf("%02d ", Radio::radio.rx_buf[i]);   // Changed to "%02d \n"
    }
    printf("\r\n\n");
}

const RadioEvents_t rev = {
    /* Dio0_top_half */     NULL,
    /* TxDone_topHalf */    NULL,
    /* TxDone_botHalf */    txDoneCB,
    /* TxTimeout  */        NULL,
    /* RxDone  */           rxDoneCB,
    /* RxTimeout  */        NULL,
    /* RxError  */          NULL,
    /* FhssChangeChannel  */NULL,
    /* CadDone  */          NULL
};

int main()
{   

    // POR & Reset debug message
        
    printf("\r\nreset-rx\r\n");
    
    Radio::Init(&rev);

    // Radio Start
    
    Radio::Standby();
    Radio::LoRaModemConfig(BW_KHZ, SPREADING_FACTOR, 1);
    Radio::SetChannel(CF_HZ);

    // preambleLen, fixLen, crcOn, invIQ
               
    Radio::LoRaPacketConfig(8, false, true, false);
    
    // Start radio receiver, wait for packets from transmitter

    Radio::Rx(0);
    
    for (;;) {     
        Radio::service();
    }
}