#include "radio.h"
 
DigitalOut myled(LED1);

#if defined(SX127x_H) || defined(SX126x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    11
    #define CF_HZ               908000000
#elif defined(SX128x_H)
    #define BW_KHZ              200
    #define SPREADING_FACTOR    11
    #define CF_HZ               2487000000
#endif

#ifdef TARGET_DISCO_L072CZ_LRWAN1
    DigitalOut pinA(PB_12);
    DigitalOut pinB(PB_13);
    DigitalOut pinC(PB_14);
    DigitalOut pinD(PB_15);
    DigitalOut syncPin(PB_8);
#else
    DigitalOut pinA(PC_2);
    DigitalOut pinB(PC_3);
    DigitalOut pinC(PC_6);
    DigitalOut pinD(PC_8);
    DigitalOut syncPin(PB_2);
#endif /* !TARGET_DISCO_L072CZ_LRWAN1 */


DigitalOut* pin; 
Timeout to;
Timeout resetTrip;

#define PIN_ASSERT_us       200000

#define CMD_PINA       0x02
#define CMD_PINB       0x03
#define CMD_PINC       0x06
#define CMD_PIND       0x08

/**********************************************************************/

void alarm_pin_clr()
{
    pin->write(0);
}


void turnOffSyncPin() 
{
    syncPin = 0;
}

void alarm_pin_set()
{
    pin->write(1);
    to.attach_us(&alarm_pin_clr, PIN_ASSERT_us);
}

void get_alarm()
{
    uint8_t byte = Radio::radio.rx_buf[0];
    if(byte != 42)return;
    
        uint8_t c = Radio::radio.rx_buf[1];
        if (c == CMD_PINA || c == CMD_PINB || c == CMD_PINC || c == CMD_PIND) 
        {
            unsigned delay;
            delay = Radio::radio.rx_buf[2];
            delay <<= 8;
            delay += Radio::radio.rx_buf[3];
            delay <<= 8;
            delay += Radio::radio.rx_buf[4];
            delay <<= 8;
            delay += Radio::radio.rx_buf[5];
            switch (c) {
                case CMD_PINA: pin = &pinA; break;
                case CMD_PINB: pin = &pinB; break;
                case CMD_PINC: pin = &pinC; break;
                case CMD_PIND: pin = &pinD; break;
            }
            if(pin == &pinA)
            {
                syncPin = 1;
                resetTrip.attach(&turnOffSyncPin, .01);
            }    
            to.attach_us(&alarm_pin_set, delay);
            printf("delay:%u\r\n", delay);
        } else
            printf("cmd? %02x\r\n", Radio::radio.rx_buf[1]);
}

void txDoneCB()
{
    
}

void rxDoneCB(uint8_t size, float Rssi, float Snr)
{
//verify ID, in this case ID is 42
   // uint8_t byte = Radio::radio.rx_buf[0];
    //if(byte != 42)return;


    get_alarm();
    printf("%.1fdBm  snr:%.1fdB ", Rssi, Snr);
}





const RadioEvents_t rev = {
    /* Dio0_top_half */     NULL,
    /* TxDone_topHalf */    NULL,
    /* TxDone_botHalf */    txDoneCB,
    /* TxTimeout  */        NULL,
    /* RxDone  */           rxDoneCB,
    /* RxTimeout  */        NULL,
    /* RxError  */          NULL,
    /* FhssChangeChannel  */NULL,
    /* CadDone  */          NULL
};

 
int main()
{   
    printf("\r\nreset-rx\r\n");


    Radio::Init(&rev);

    Radio::Standby();
    Radio::LoRaModemConfig(BW_KHZ, SPREADING_FACTOR, 1);
    Radio::LoRaPacketConfig(8, false, true, false);  // preambleLen, fixLen, crcOn, invIQ
    Radio::SetChannel(CF_HZ);
    
    Radio::Rx(0);
    
    for (;;) {     
        Radio::service();
    }
}
