//#include "user_platform.h"
#include "radio.h"

#if defined(SX127x_H) || defined(SX126x_H)
    #define BW_KHZ              500
    #define SPREADING_FACTOR    11
    #define CF_HZ               908000000
    #if defined(SX126x_H)
        #define TX_DBM              (Radio::chipType == CHIP_TYPE_SX1262 ? 20 : 14) 
    #else
        #define TX_DBM              17
    #endif
#elif defined(SX128x_H)
    #define BW_KHZ              200
    #define SPREADING_FACTOR    11
    #define CF_HZ               2487000000

    #define TX_DBM              5
#endif

#ifdef TARGET_DISCO_L072CZ_LRWAN1
    DigitalIn pinA(PB_12);
    DigitalIn pinB(PB_13);
    DigitalIn pinC(PB_14);
    DigitalIn pinD(PB_15);
#elif defined(TARGET_FF_MORPHO)
    DigitalIn pinA(PC_3);
    DigitalIn pinB(PC_2);
    DigitalIn pinC(PC_6);
    DigitalIn pinD(PC_8);
#endif 

volatile struct _f_ {
    uint8_t enable_pin_A : 1;
    uint8_t enable_pin_B : 1;
    uint8_t enable_pin_C : 1;
    uint8_t enable_pin_D : 1;
} flags;
 
Timer t;
#define CMD_PINA       0x02
#define CMD_PINB       0x03
#define CMD_PINC       0x06
#define CMD_PIND       0x08

uint8_t ID_byte = 42;

volatile bool tx_done;

void transmit(unsigned target, uint8_t cmd)
{
    unsigned t_diff;
    
    Radio::radio.tx_buf[0] = ID_byte;
    Radio::radio.tx_buf[1] = cmd;
    t_diff = target - t.read_us();
    Radio::radio.tx_buf[2] = t_diff >> 24;
    Radio::radio.tx_buf[3] = t_diff >> 16;
    Radio::radio.tx_buf[4] = t_diff >> 8;
    Radio::radio.tx_buf[5] = t_diff & 0xff;
    
    Radio::Send(6, 0, 0, 0);

    for (tx_done = false; !tx_done; )
        Radio::service();

}

#define TARGET_LATENCY      1820500
void send_alarm(uint8_t cmd)
{
    int i;
    unsigned target = t.read_us() + TARGET_LATENCY;
    printf("send_alarm() %u\n", target);

    for (i = 0; i < 6; i++) {
        transmit(target, cmd);
        wait(0.1);
    }
}

void debounce(DigitalIn* pin, uint8_t cmd)
{
    if (!pin->read()) {
        int i;
        for (i = 0; i < 5; i++) {
            wait(0.01);
            if (pin->read()) {
                printf("trans\r\n");
                break;
            }
        }
        if (i == 5)
            send_alarm(cmd);

        while (!pin->read())
            ;
    }
}

void txDoneCB()
{
    tx_done = true;
}

void rxDoneCB(uint8_t size, float Rssi, float Snr)
{
}

const RadioEvents_t rev = {
    /* Dio0_top_half */     NULL,
    /* TxDone_topHalf */    NULL,
    /* TxDone_botHalf */    txDoneCB,
    /* TxTimeout  */        NULL,
    /* RxDone  */           rxDoneCB,
    /* RxTimeout  */        NULL,
    /* RxError  */          NULL,
    /* FhssChangeChannel  */NULL,
    /* CadDone  */          NULL
};

int main()
{
    printf("\r\nreset-tx\r\n");

    pinA.mode(PullUp);
    pinB.mode(PullUp);
    pinC.mode(PullUp);
    pinD.mode(PullUp);

    wait(0.05);

    if (pinA.read() == 0) {
        printf("pinA-disabled\r\n");
        flags.enable_pin_A = 0;
    } else
        flags.enable_pin_A = 1;

    if (pinB.read() == 0) {
        printf("pinB-disabled\r\n");
        flags.enable_pin_B = 0;
    } else
        flags.enable_pin_B = 1;

    if (pinC.read() == 0) {
        printf("pinC-disabled\r\n");
        flags.enable_pin_C = 0;
    } else
        flags.enable_pin_C = 1;

    if (pinD.read() == 0) {
        printf("pinD-disabled\r\n");
        flags.enable_pin_D = 0;
    } else
        flags.enable_pin_D = 1;

    t.start();

    Radio::Init(&rev);

    Radio::Standby();
    Radio::LoRaModemConfig(BW_KHZ, SPREADING_FACTOR, 1);
    Radio::LoRaPacketConfig(8, false, true, false);  // preambleLen, fixLen, crcOn, invIQ
    Radio::SetChannel(CF_HZ);

    Radio::set_tx_dbm(TX_DBM);
                
    for (;;) {       
        if (flags.enable_pin_A)
            debounce(&pinA, CMD_PINA);

        if (flags.enable_pin_B)
            debounce(&pinB, CMD_PINB);

        if (flags.enable_pin_C)
            debounce(&pinC, CMD_PINC);

        if (flags.enable_pin_D)
            debounce(&pinD, CMD_PIND);
    } // ..for (;;)
}
