#include "mbed.h"
#include "TextLCD.h" 

BusOut saida (D4,D5,D6,D7,D8,D9,D10,D11);
Serial pc(USBTX , USBRX);// band rate é de 1152000 na Serial Port do Tera Term
TextLCD lcd(PC_9, PC_8, PC_10, PC_12, PA_13, PA_14, TextLCD::LCD20x4); // rs, e , d4-d7
DigitalIn botao_enter(PA_15); 
DigitalIn botao_ciclo(PB_7);
int lista[] = {15,15,14,13,12,11,10,8,7,5,4,2,1,1,0,0};
//IHM
int menu = 0;
int linha = 1;
int freq[] = {10,500};
bool troca_freq = 0 ;
int t; // tempo de espera
void senoidal(int frequencia)
{   
     t = (1/(16*frequencia));
     
    for (int i = 0 ; i < 16 ; i++)
            {
                
                saida = lista[i];
                wait(t);  
                if ( i ==15)
                {   for ( int i = 15; i >= 0; i--)
                    {
                        saida = lista[i];
                        wait(t);
                    }
                }
            }
}
void triangular(int frequencia)
{   int k = 0;
    if (k == 0)
    t = (1/(16*frequencia));
    {
        for (int i = 0; i <= 15; i++)
        {
            saida = i;
            wait(t/2);
            if (i ==15)
            {    
                k = 1;
            }
        }
    }
        
    if (k == 1)
    {
        for (int i = 15; i >= 0; i--)
        {
            saida = i;
            wait(t/2);
            if (i == 0)
            {    
                k = 0;
            }
        }
    }
}
void quadrado(int frequencia)
{  
    t = (1/(16*frequencia));
    saida = 15;
    wait(t);
    saida = 0;
    wait(t);
 
}   
int main()
{
    while(1)
    {   
        //triangular();
        //senoidal(freq[0]);
        quadrado();
        pc.baud(115200);
    //------------------------------------------------------------------------------Menu = 0 tela inicial------------------------------------------------------------------
        if (menu == 0 )
        {   
            lcd.cls();
            saida = 0;//Não emite sinal
            lcd.printf("Gerador de Ondas \n");
            lcd.printf("  Triangular\n");
            lcd.printf("  Senoidal\n");
            lcd.printf("  Quadrado\n");
            lcd.locate(0,linha);
            lcd.putc('>');
            wait(0.2);
                //botao_cima.fall(&cima_cursor);
            menu = -1;
        }// if menu = 1
        //------------------------------------------------------------------------------Botao Ciclo------------------------------------------------------------------
        if (botao_ciclo== 0)
        {
            pc.printf(" linha=%i menu=%i\r\n",linha, menu);
            if (menu == -1 )
            {
                linha++;
                if (linha == 4)
                {   
                    linha =1;
                    lcd.locate(0,3);
                    lcd.putc(' ');
                    lcd.locate(0,linha);
                    lcd.putc('>');
                }
                if (linha < 4 and linha > 1)
                {
                    lcd.locate(0,linha-1);
                    lcd.putc(' ');
                    lcd.locate(0,linha);
                    lcd.putc('>');
                }
                wait(0.2);
                menu = -1;
            }
            if (menu == -2 or menu == -3 or menu == -4)
            {
                linha++;
                if (linha == 4)
                {   
                    linha =1;
                    lcd.locate(0,3);
                    lcd.putc(' ');
                    lcd.locate(0,linha);
                    lcd.putc('>');
                }
                if (linha < 4 and linha > 1)
                {
                    lcd.locate(0,linha-1);
                    lcd.putc(' ');
                    lcd.locate(0,linha);
                    lcd.putc('>');
                }
                wait(0.2);
                //menu = -2;
            }
        }
            //------------------------------------------------------------------------------Botao Enter------------------------------------------------------------------
        if (botao_enter == 0)
        {   
            pc.printf(" linha=%i menu=%i\r\n",linha, menu);
            if (menu== -1)
            {
                wait(0.2);
                if (linha == 1)
                {
                    menu = 1;// menu para a triangular
                }
                if (linha == 2)
                {
                    menu = 2;// menu para a triangular
                }
                if (linha == 3)
                {
                    menu = 3;// menu para a triangular
                }
            }
            if (menu== -2)//triangular
            {
                
                if (linha == 1)
                {   
                    troca_freq= !troca_freq;
                    lcd.cls();
                    lcd.printf(" Triangular \n");
                    lcd.printf("  Freq: %d Hz\n", freq[troca_freq]);
                    lcd.printf("  Gerar\n");
                    lcd.printf("  Voltar\n");
                    linha = 1;
                    lcd.locate(0,linha);
                    lcd.putc('>');
                    wait(0.2);
                    menu = -2;
                }
                if (linha == 3)
                {
                    menu = 0;   
                }
                if (linha == 2)
                {
                    
                    while(botao_ciclo == 1)
                    {
                        triangular(freq[troca_freq]);   
                    }
                }
            }   
            if (menu== -3)//senoidal
            {
                
                if (linha == 1)
                {   
                    troca_freq= !troca_freq;
                    lcd.cls();
                    lcd.printf(" Senoidal \n");
                    lcd.printf("  Freq: %d Hz\n", freq[troca_freq]);
                    lcd.printf("  Gerar\n");
                    lcd.printf("  Voltar\n");
                    linha = 1;
                    lcd.locate(0,linha);
                    lcd.putc('>');
                    wait(0.2);
                    menu = -3;
                }
                if (linha == 3)
                {
                    menu = 0;   
                }
                if (linha == 2)
                {
                    pc.printf("%d\r\n",freq[troca_freq]);
                    while(botao_ciclo == 1)
                    {
                        senoidal(freq[troca_freq]);   
                    }
                }
            }
            if (menu== -4)//quadrado
            {
                
                if (linha == 1)
                {   
                    troca_freq= !troca_freq;
                    lcd.cls();
                    lcd.printf(" Quadrado \n");
                    lcd.printf("  Freq: %d Hz\n", freq[troca_freq]);
                    lcd.printf("  Gerar\n");
                    lcd.printf("  Voltar\n");
                    linha = 1;
                    lcd.locate(0,linha);
                    lcd.putc('>');
                    wait(0.2);
                    menu = -4;
                }
                if (linha == 3)
                {
                    menu = 0;   
                }
                if (linha == 2)
                {
                    
                    while(botao_ciclo == 1)
                    {
                        quadrado(freq[troca_freq]);   
                    }
                }
            }   
        }
        //------------------------------------------------------------------------------ menu =1 menu tragular------------------------------------------------------------------
        if (menu == 1)
            {   lcd.cls();
                lcd.printf(" Triangular \n");
                lcd.printf("  Freq: %d Hz\n", freq[0]);
                lcd.printf("  Gerar\n");
                lcd.printf("  Voltar\n");
                linha = 1;
                lcd.locate(0,linha);
                lcd.putc('>');
                menu = -2;
                wait(0.2);
            }
        //------------------------------------------------------------------------------ menu =2 menu Senoidal------------------------------------------------------------------
        if (menu == 2)
            {   lcd.cls();
                lcd.printf(" Senoidal \n");
                lcd.printf("  Freq: %d Hz\n", freq[0]);
                lcd.printf("  Gerar\n");
                lcd.printf("  Voltar\n");
                linha = 1;
                lcd.locate(0,linha);
                lcd.putc('>');
                menu = -3;
                wait(0.2);
            }   
        //------------------------------------------------------------------------------ menu =3 menu Quadrado------------------------------------------------------------------
        if (menu == 3)
            {   lcd.cls();
                lcd.printf(" Quadrado \n");
                lcd.printf("  Freq: %d Hz\n", freq[0]);
                lcd.printf("  Gerar\n");
                lcd.printf("  Voltar\n");
                linha = 1;
                lcd.locate(0,linha);
                lcd.putc('>');
                menu = -4;
                wait(0.2);
            }   
    }   
}