#include "mbed.h"

Timeout flipper;

Serial host_pc(USBTX, USBRX); // tx, rx

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

AnalogIn pin_15(p15);
DigitalOut pin_17(p17);     // used as virtual gnd
DigitalIn pin_16(p16);      // usded as charger

AnalogIn pin_20(p20);
DigitalOut pin_18(p18);     // used as virtual gnd
DigitalIn pin_19(p19);      // usded as charger

bool verbose = false;               // verbose mode flag

bool if_S;                  // if the serial port see a S before E

//flags
bool if_timer_expired;

int i;
int pre_state;
int user_input[64];     // 0 for invalid
int* string;         // 1 for T0
int string_in[64];      // 2 for T1

int TouchSense();
void process_serial(char char_readin);
void update_user_input();  // fucntion for user_mode
void reset_host();
void check_string();
void timer_toggle();
void V_PT_WAIT_UNTIL_T_S();     // virtual PT_WAIT_UNTIL(timer_expired||serial_ready)

 int main() {
    // initial the system
    // assume the string length is less than 64
    if_S = false;
    pre_state = 0;          
    string = new int [64];
    for (i=0;i<64;i++)
    {
        user_input[i] = 0;
        string_in[i] = 0;
        string[i] = 0;
    }
    
 
    // set the thread
    while(1) 
    {
        flipper.attach(&timer_toggle, 0.0045);  //set timer
        if_timer_expired = false;
        
        V_PT_WAIT_UNTIL_T_S(); // PT_WAIT_UNTIL(timer_expired||serial_ready)
        
        while ( !if_timer_expired )
        {
            if (verbose)
            {
                host_pc.printf("detect input, not yet expired");
                host_pc.putc(10);
                host_pc.putc(13);
            }
            
            process_serial(host_pc.getc());
                        
            V_PT_WAIT_UNTIL_T_S(); // PT_WAIT_UNTIL(timer_expired||serial_ready)
        }
        
        update_user_input();
        
    }
    
 }
 
 void V_PT_WAIT_UNTIL_T_S()
 {
    while (1)
    {
        if ( if_timer_expired || host_pc.readable() )
            break;
    }
 }
 
 
 void timer_toggle()
 {
    if_timer_expired = true;
 }
 
 void update_user_input()
 {
    
      
    int input = TouchSense();
    if (input == pre_state) //check whether the input has changed
    {
    }
    else
    {
        pre_state = input;
        switch (input)
        {
            case 0:
                break;
            case 1:
                // detect an input T0, shift all input trace
                for (i=63;i>0;i--)
                {
                    user_input[i] = user_input[i-1];
                }
                user_input[0] = 1;
                check_string();
                break;
            case 2:
                // detect an input T1, shift all input trace
                for (i=63;i>0;i--)
                {
                    user_input[i] = user_input[i-1];
                }
                user_input[0] = 2;
                check_string();
                break;
            case 3:
                host_pc.printf("TOUCH ERROR");
                host_pc.putc(10);
                host_pc.putc(13);
                break;
            default:
                break;
        }
        if (verbose)
        {
            if (input ==0)
            {
                myled1 = 1;
                myled2 = 0;
                myled3 = 0;
                myled4 = 0;
            }
            else if (input ==1)
            {
                myled1 = 0;
                myled2 = 1;
                myled3 = 0;
                myled4 = 0;
                host_pc.printf("Input Detected: 0");
                host_pc.putc(10);
                host_pc.putc(13);
            }
            else if (input ==2)
            {
                myled1 = 0;
                myled2 = 0;
                myled3 = 1;
                myled4 = 0;
                host_pc.printf("Input Detected: 1");
                host_pc.putc(10);
                host_pc.putc(13);
            }
            else
            {
                myled1 = 0;
                myled2 = 0;
                myled3 = 0;
                myled4 = 1;
            }
        }
    }
    
    
 }
 
 void process_serial(char char_readin)
 {
    switch (char_readin)
    {
        case 'S':
            if (if_S)
            {
                host_pc.printf("HOST ERROR");
                host_pc.putc(10);   //start new line
                host_pc.putc(13);   //reset cursor location
                reset_host();
            }
            else
            {
                // refresh string_in
                for (i=0;i<64;i++)
                {
                    string_in[i] = 0;
                }
                // set start flag
                if_S = true;
            }
            break;            
        case 'E':
            if (if_S)
            {
                if ( string_in[0] == 0 )
                {
                    host_pc.printf("HOST ERROR");
                    if (verbose)
                    {
                        host_pc.printf(": no string defined");
                    }
                    
                    host_pc.putc(10);   //start new line
                    host_pc.putc(13);   //reset cursor location
                    
                    reset_host();
                    break;
                }
                
                // detect the length of string
                int string_length;
                for (i=0;i<64;i++)
                {
                    if (string_in[i] == 0)
                    {
                        break;
                    }
                }
                string_length = --i;
                
                int* string_buffer = new int [64];
                
                for (i=0;i<64;i++)
                {
                    if (i<=string_length)
                    {
                        string_buffer[i] = string_in[string_length-i];
                    }
                    else
                    {
                        string_buffer[i] = 0;
                    }
                }
                int * buffer = string;
                string = string_buffer;     // hope that this operation will not be interrupted, at least the interrupted should not be a problem because either value is valid
                delete [] buffer;
                
                
                // unset start flag
                if_S = false;
                
                if (verbose)
                {
                    host_pc.printf("Input finishes, the sequency is\t");
                    for (i=0;i<64;i++)
                    {
                        if (string[i] == 0)
                        {
                            break;
                        }
                        else
                        {
                            host_pc.printf("%d", string[i]-1);
                        }
                    }
                    host_pc.putc(10);
                    host_pc.putc(13);
                }
            }
            else
            {
                host_pc.printf("HOST ERROR");
                host_pc.putc(10);   //start new line
                host_pc.putc(13);   //reset cursor location
                reset_host();
            }
            break;
        case '0':
            if (if_S)
            {
                // check the next string_in write location
                for (i=0;i<64;i++)
                {
                    if ( string_in[i] == 0)
                    {
                        break;
                    }
                }
                if ( i == 64 )
                {
                    host_pc.printf("ERROR: Input String is Too Long");
                    host_pc.putc(10);   //start new line
                    host_pc.putc(13);   //reset cursor location
                    reset_host();
                }
                else
                {
                    string_in[i] = 1;
                }
                
            }
            else
            {
                host_pc.printf("HOST ERROR");
                host_pc.putc(10);   //start new line
                host_pc.putc(13);   //reset cursor location
                reset_host();
            }
            break;
        case '1':
            if (if_S)
            {
                // check the next string_in write location
                for (i=0;i<64;i++)
                {
                    if ( string_in[i] == 0)
                    {
                        break;
                    }
                }
                if ( i == 64 )
                {
                    host_pc.printf("ERROR: Input String is Too Long");
                    host_pc.putc(10);   //start new line
                    host_pc.putc(13);   //reset cursor location
                    reset_host();
                }
                else
                {
                    string_in[i] = 2;
                }
                
            }
            else
            {
                host_pc.printf("HOST ERROR");
                host_pc.putc(10);   //start new line
                host_pc.putc(13);   //reset cursor location
                reset_host();
            }
            break;
        case ' ':
            break;
        default:
            host_pc.printf("HOST ERROR");
            host_pc.putc(10);   //start new line
            host_pc.putc(13);   //reset cursor location
            reset_host();
    }
 }
 
 
 
 // return 0:no input; 1:lower iput only; 2:higher input only; 3:both input
 int TouchSense(void)
 {
 
     float sensor_readin0;
     float sensor_readin1;
     
     pin_17 = 0;                //set the gnd
     pin_18 = 0;                //set the gnd
     pin_16.mode(PullUp);       //set up the charger
     pin_19.mode(PullUp);       //set up the charger 
     wait(0.0005);
     pin_16.mode(PullNone);    //finish the charging
     pin_19.mode(PullNone);    //finish the charging
     
     sensor_readin1=pin_15.read();
     sensor_readin0=pin_20.read();
     if ( sensor_readin0 < 0.7 )   //
     {
        if ( sensor_readin1 < 0.7 )
        {
            return 3;
        }
        else
        {
            return 1;
        }
     }
     else
     {
        if ( sensor_readin1 < 0.7 )
        {
            return 2;
        }
        else
        {
            return 0;
        }
     } 
    
 }
 void reset_host()
 {
    if_S = false;
    for (i=0;i<64;i++)
    {
        string_in[i] = 0;
    }
    if (verbose)
    {
        host_pc.printf("Reset host, redo string input\n");
        host_pc.putc(10);
        host_pc.putc(13);
    }
 }
 
 void check_string()
 {
    // check user_input and string
    bool if_identical = true;
    if (string[0]==0)
        return;
    for (i=0;i<64;i++)
    {
        if (string[i])
        {
            if (string[i] != user_input[i])
            {
                if_identical = false;
                continue;
            }
        }
        else
        {
            break;
        }
    }
    if (if_identical)
    {
        host_pc.printf("MATCH");
        host_pc.putc(10);
        host_pc.putc(13);
    }
 }