
#include "mbed.h"
#include "dac.h"
#include "board_test.h"
#include "scan.h"
#include "power.h"
#include "pinout.h"
#include "pll.h"
#include "lcd.h"
#include "jtag.h"
#include "mmap.h"
#include "clock.h"
#include "EasyBMP.h"
#include "main.h"

//#define WRITE_RESULTS
FILE *results_file;

DigitalOut myled(LED4);
#ifdef WRITE_RESULTS
//LocalFileSystem local("local");               // Create the local filesystem under the name "local"
#endif

int main()
{
    float core_volt = 1;
#ifdef WRITE_RESULTS
    results_file=fopen("/local/results.txt", "a");  // Open "out.txt" on the local file system for writing
#endif

    // power up the board
    pc.printf("Begin\r\n");
    power_down();
    power_up(core_volt); // Power Up Chip
    pc.printf("Powered up!\r\n");
    pc.printf("Start reading IDCode...\r\n");

    // initializing the resets
    PORESETn = 0;
    CORERESETn = 0;
    wait_us(100);
    PORESETn = 1;
    CORERESETn = 1;
    JTAG jtag;

    // read and verify chip ID
    int idcode = jtag.readID();
    if(idcode != 0x4ba00477) {
        pc.printf("ERROR: IDCode %X\r\n", idcode);
        wait(2);
        power_down();
        return -1;
    }
    pc.printf("IDCode %X\r\n", idcode);

    // power up the JTAG port
    jtag.reset();
    jtag.leaveState();
    jtag.PowerupDAP();

    // setup necessary internal clock source selection
    jtag.writeMemory(intclk_source, 2);
    jtag.writeMemory(extclk_source, 1);
    jtag.writeMemory(ext_div_by, 10);

    float voltage=1;
    power_core(voltage);
    pc.printf("V: %f\r\n", voltage);

    // load program
    if(jtag.loadProgram()) {
        dual_printf("Load Failed");
        exit(1);
    }
    
    // reset the core and let it run
    CORERESETn = 0;
    CORERESETn = 1;
    wait(0.2);
    
    // open the JTAG port again
    jtag.reset();
    jtag.leaveState();
    jtag.PowerupDAP();
    
    // verify the output here with the following functions
    // unsigned int readMemory(unsigned int address);
    // void writeMemory(unsigned int address, unsigned int value);
    
    
    pc.printf("Powering Down\r\n");
    power_down();
    pc.printf("Done\r\n");
    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}

int check_FFT_Freq(JTAG &jtag, int fMHz)
{
    if(jtag.loadProgram()) {
        dual_printf("Load Failed");
        exit(1);
    }
    set_pll_frequency (fMHz, jtag);
    //dual_printf("Resetting");
    CORERESETn = 0;
    CORERESETn = 1;
    wait(0.2);
    jtag.reset();
    jtag.leaveState();
    jtag.PowerupDAP();
    unsigned int buffer_fft[64];
    for (int number1=0; number1<=63; number1++) {
        buffer_fft[number1] = jtag.readMemory(0x24000100 + number1*4);
        jtag.writeMemory(0x24000100 + number1*4,0xF0F0F0F0);
        //printf("new[%d]: %d\r\n", number1, buffer_fft[number1]);
    }
    if ( buffer_fft[0] == 0x0000fffc && buffer_fft[1]==0x0000fffd && buffer_fft[2]==0xffc0000a && buffer_fft[3]==0x0000fffe &&
            buffer_fft[4]==0x0000fffd && buffer_fft[5]==0x0000ffff && buffer_fft[6]==0x0000fffd && buffer_fft[7]==0x00000000 &&
            buffer_fft[8]==0x0000ffff && buffer_fft[9]==0x0000ffff && buffer_fft[10]==0xfffeffff && buffer_fft[11]==0xffff0000 &&
            buffer_fft[12]==0x0000ffff && buffer_fft[13]==0xffff0000 && buffer_fft[14]==0xfffffffe && buffer_fft[15]==0xffff0000 &&
            buffer_fft[16]==0x00010000  && buffer_fft[17]==0x0001ffff && buffer_fft[18]==0x0000ffff && buffer_fft[19]==0x0001ffff &&
            buffer_fft[20]==0x0001fffe && buffer_fft[21]==0x0000fffe && buffer_fft[22]==0x0001fffe && buffer_fft[23]==0x0000ffff &&
            buffer_fft[24]==0x0000ffff && buffer_fft[25]==0x0001fffe && buffer_fft[26]==0x0000ffff && buffer_fft[27]==0x00010000 &&
            buffer_fft[28]==0x0001ffff && buffer_fft[29]==0x00010000 && buffer_fft[30]==0x0000ffff && buffer_fft[31]==0x00010000 &&
            buffer_fft[32]==0x0000ffff && buffer_fft[33]==0x0000ffff && buffer_fft[34]==0x0000ffff && buffer_fft[35]==0x0000ffff &&
            buffer_fft[36]==0x0000fffe && buffer_fft[37]==0x0000ffff && buffer_fft[38]==0x0000fffe && buffer_fft[39]==0x00000000 &&
            buffer_fft[40]==0xffffffff && buffer_fft[41]==0x0000ffff && buffer_fft[42]==0xffffffff && buffer_fft[43]==0x00000000 &&
            buffer_fft[44]==0x0000ffff && buffer_fft[45]==0x00000000 && buffer_fft[46]==0xffffffff && buffer_fft[47]==0x00000000 &&
            buffer_fft[48]==0x00000000 && buffer_fft[49]==0x00000000 && buffer_fft[50]==0x00000000 && buffer_fft[51]==0x00000000 &&
            buffer_fft[52]==0x0000ffff && buffer_fft[53]==0x0000ffff && buffer_fft[54]==0x0000ffff && buffer_fft[55]==0x00000000 &&
            buffer_fft[56]==0xfffeffff && buffer_fft[57]==0xffffffff && buffer_fft[58]==0xffff0000 && buffer_fft[59]==0x00000000 &&
            buffer_fft[60]==0x0000ffff && buffer_fft[61]==0x00000000 && buffer_fft[62]==0x003d000c && buffer_fft[63]==0x00000000 ) {
        return 1;
    } else {
        return 0;
    }
}

void DDRO_Sensor(JTAG &jtag)
{
    /**********************enable****************************************/
    jtag.writeMemory(ddro_syn_en, 0xffffffff);
    jtag.writeMemory(ddro_inv_en, 0xffffffff);
    /**********************set ref_clk and samp_clk**********************/
    jtag.writeMemory(ddro_ref_src, 0x00000002);
    /**********************write threshold*******************************/
    jtag.writeMemory(ddro_threshold, 100000);
    //jtag.writeMemory(0xe000e104, 0x000000ff); // enable interrupts

    for (int ro_id=3; ro_id<=15; ro_id++) {
        unsigned int meas1_s, meas1_e, meas2_s, meas2_e;
        int delta1, delta2;
        //pc.printf("RO %d\r\n ", ro_id-2);
        jtag.writeMemory(ddro_samp_src, ro_id);
        jtag.writeMemory(ddro_start, 0);
        meas1_s = jtag.readMemory(ddro_count);
        //pc.printf("Counter starts at: %d  ", meas1);
        jtag.writeMemory(ddro_start, 1);
        wait_us(50000);
        jtag.writeMemory(ddro_start, 0);
        meas1_e = jtag.readMemory(ddro_count);
        //pc.printf("ends at: %d\r\n", meas1);
        delta1 = meas1_e - meas1_s;

        jtag.writeMemory(ddro_samp_src, ro_id);
        jtag.writeMemory(ddro_start, 0);
        meas2_s = jtag.readMemory(ddro_count);
        //pc.printf("Counter starts at: %d  ", meas1);
        jtag.writeMemory(ddro_start, 1);
        wait_us(50000);
        jtag.writeMemory(ddro_start, 0);
        meas2_e = jtag.readMemory(ddro_count);
        delta2 = meas2_e - meas2_s;
        //printf("ends at: %d\r\n", meas1);

        if ( (float)delta2/meas1_e>=0.95 && (float)delta2/meas1_e<=1.05 ) {
            pc.printf("RO %d:  %d\r\n", ro_id, (delta2+meas1_e)/2);
#ifdef WRITE_RESULTS
            fprintf(results_file,"RO %d:  %d\r\n", ro_id, (delta2+meas1_e)/2);
#endif
        } else if ((float)delta1/meas2_e>=0.95 && (float)delta1/meas2_e<=1.05 ) {
            pc.printf("RO %d:  %d\r\n", ro_id, (delta1+meas2_e)/2);
#ifdef WRITE_RESULTS
            fprintf(results_file,"RO %d:  %d\r\n", ro_id, (delta1+meas2_e)/2);
#endif
        } else if ( (float)delta2/delta1 >=0.95 && (float)delta2/delta1<=1.05 ) {
            pc.printf("RO %d:  %d\r\n", ro_id, (delta1+delta2)/2);
#ifdef WRITE_RESULTS
            fprintf(results_file,"RO %d:  %d\r\n", ro_id, (delta1+delta2)/2);
#endif
        } else if ( (float)meas2_e/meas1_e >=0.95 && (float)meas2_e/meas1_e<=1.05 ) {
            pc.printf("RO %d:  %d\r\n", ro_id, (meas1_e+meas2_e)/2);
#ifdef WRITE_RESULTS
            fprintf(results_file,"RO %d:  %d\r\n", ro_id, (meas1_e+meas2_e)/2);
#endif
        } else {
            pc.printf("Error in measuring DDRO %d\r\n", ro_id);
#ifdef WRITE_RESULTS
            fprintf(results_file,"Error in measuring DDRO %d\r\n", ro_id);
#endif
        }
    }
}
