//slave
//note: main() function is at the bottom
#include <mbed.h>
#include <sstream>
using namespace std;

I2CSlave slave(p9, p10);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
Serial pc(USBTX, USBRX);

Ticker CLK;

DigitalOut leakage_enable(p15);
AnalogIn leakage1(p17);
AnalogIn leakage2(p18);

DigitalOut ref_clk(p5);
DigitalOut count(p6);
DigitalOut read(p7);
DigitalOut enable(p8);
DigitalOut S0(p11);
DigitalOut S1(p12);
DigitalOut S2(p13);
DigitalOut S3(p14);
DigitalOut S4(p22);
DigitalOut S5(p21);
DigitalOut OS(p16);
DigitalIn O0(p23);
DigitalIn O1(p24);
DigitalIn O2(p25);
DigitalIn O3(p29);
DigitalIn O4(p28);
DigitalIn O5(p27);
DigitalIn O6(p26);
DigitalIn O7(p30);
AnalogIn core(p19);
AnalogIn sram(p20);

char buf[50] = {};
char msg[] = "Slave!";
const int SLAVEADDR = 0x88; // define the I2C Slave Address (mbed 2)

void clk_gen()
{
    ref_clk = !ref_clk;
}

void assign_s(int selection)
{
    int remainder = selection;
    S0 = selection % 2;
    selection = selection / 2;
    S1 = selection % 2;
    selection = selection / 2;
    S2 = selection % 2;
    selection = selection / 2;
    S3 = selection % 2;
    selection = selection / 2;
    S4 = selection % 2;
    selection = selection / 2;
    S5 = selection % 2;
}

unsigned int read_out()
{
    unsigned int out;
    out = 0;
    OS = 1;
    wait(0.001);
    out += O7.read();
    out *= 2;
    out += O6.read();
    out *= 2;
    out += O5.read();
    out *= 2;
    out += O4.read();
    out *= 2;
    out += O3.read();
    out *= 2;
    out += O2.read();
    out *= 2;
    out += O1.read();
    out *= 2;
    out += O0.read();
    out *= 2;
    OS = 0;
    wait(0.001);
    out += O7.read();
    out *= 2;
    out += O6.read();
    out *= 2;
    out += O5.read();
    out *= 2;
    out += O4.read();
    out *= 2;
    out += O3.read();
    out *= 2;
    out += O2.read();
    out *= 2;
    out += O1.read();
    out *= 2;
    out += O0.read();
    return out;
}

void scan_slave(char* ro_data)
{
    pc.printf("Testing Starts here\n");
    O0.mode(PullUp);
    O1.mode(PullUp);
    O2.mode(PullUp);
    O3.mode(PullUp);
    O4.mode(PullUp);
    O5.mode(PullUp);
    O6.mode(PullUp);
    O7.mode(PullUp);

    count = 0;
    read = 0;
    enable = 0;
    int i;

    for (i=0; i<64; i++) {
        //measure using 0.01
        CLK.detach();
        CLK.attach(&clk_gen, 0.01);
        int select = i;
        enable = 0;
        count = 0;
        read = 0;
        assign_s(select);
        wait_us(100);
        enable = 1;
        wait_us(100);
        count = 1;
        wait_us(100);
        count = 0;
        wait(0.2);
        read = 0;
        wait_us(100);
        read = 1;
        wait_us(100);
        read = 0;
        enable = 0;
        unsigned int out;
        out = read_out();
        ro_data[5*i] = (char)(out%10+48);
        out = out / 10;
        ro_data[5*i+1] = (char)(out%10+48);
        out = out / 10;
        ro_data[5*i+2] = (char)(out%10+48);
        out = out / 10;
        ro_data[5*i+3] = (char)(out%10+48);
        out = out / 10;
        ro_data[5*i+4] = (char)(out%10+48);
        CLK.detach();
    }
}

void read_power(char* ro_data)
{
    unsigned short core_reading = core.read_u16();
    unsigned short sram_reading = sram.read_u16();
    ro_data[64*5] = (core_reading%0x100);
    ro_data[64*5+1] = (core_reading/0x100);
    ro_data[64*5+2] = (sram_reading%0x100);
    ro_data[64*5+3] = (sram_reading/0x100);
}

void read_leakage(char* ro_data)
{
    double reading1;
    CLK.detach();
    leakage_enable = 1;

    S4 = 0;
    S5 = 0;
    ref_clk=0;
    wait(0.01);

    int i0;
    i0=0;
    ref_clk = 1;
    S5 = 1;
    do {
        i0++;
        if(i0>10000) {
            break;
        }
        wait(0.001);
        reading1 = leakage1.read();
        reading1 *= 3.3;
    } while (reading1 >0.01);
    ref_clk = 0;
    S5 = 0;
    wait(0.01);

    ro_data[64*5+4] = (i0%0x100);
    ro_data[64*5+5] = (i0/0x100);

    S4 = 1;
    wait(0.01);
    i0=0;
    ref_clk = 1;
    S5 = 1;
    do {
        i0++;
        if(i0>10000) {
            break;
        }
        wait(0.001);
        reading1 = leakage2.read();
        reading1 *= 3.3;
    } while (reading1 <3.29);
    ref_clk = 0;
    S5 = 0;
    wait(0.1);
    ro_data[64*5+6] = (i0%0x100);
    ro_data[64*5+7] = (i0/0x100);
    
    leakage_enable = 0;
}

void scan_test()
{
    slave.address(SLAVEADDR);
    char* ro_data;
    ro_data = new char[64*5+8];
    bool if_ready = false;
    while (1) {
        int i = slave.receive();
        //pc.printf("receive = %i\r\n", i);
        switch (i) {
            case I2CSlave::ReadAddressed:
                if (!if_ready) {
                    pc.printf("Slave is not ready...\n");
                    break;
                }
                slave.write(ro_data, 64*5+8);
                pc.printf("Slave is writing..\n");
                break;
            case I2CSlave::WriteGeneral:
                led2 = !led2;
                break;
            case I2CSlave::WriteAddressed:
                slave.read(buf, 4);
                pc.printf("Slave gets: %s\n", buf);
                led3 = !led3;
                char cmd1[] = "scan";
                char cmd2[] = "getp";
                char cmd3[] = "getl";
                if (!strcmp(cmd1, buf)) {
                    pc.printf("Scanning....\n");
                    scan_slave(ro_data);
                    read_power(ro_data);
                    read_leakage(ro_data);
                    if_ready = true;
                } else if (!strcmp(cmd2, buf)) {
                    pc.printf("Measuring power....\n");
                    read_power(ro_data);
                } else if (!strcmp(cmd3, buf)) {
                    pc.printf("Measuring leakage.....\n");
                    read_leakage(ro_data);
                }
                break;
        }
        for (int i = 0; i < 50; i++) buf[i] = 0;   // Clear buffer
        wait(0.002);
    }
}


//// MAIN FUNCTION
int main ()
{
    //scan_slave(); //main() function from the original DDRO_scan code
    pc.printf("SlaveMBED starts...\n");
    scan_test();

    return 0;
}