#include "power_up.h"
#include "scan.h"
#include "master_i2c.h"
#include "JTAG.h"
using namespace std;

#define FILE_OUTPUT

DigitalOut RESET (p21);

Serial s(USBTX, USBRX);
DigitalOut finish_flag (LED3);

/*
int main()
{

    PLL clk;
    JTAG jtag;

    powerReset();
    powerUp(1);
    wait_us(10);
    RESET=1;
    wait_us(10);
    RESET=0;
    wait_us(10);
    RESET=1;
    clk.setPLL(100);
    RESET=0;
    wait_us(10);
    RESET=1;
    jtag.DAP_enable();
    unsigned int address, value;
    jtag.loadProgram();
    address = 0x44000008;
    value = 0x00000001;
    jtag.writeMemory(address, value);

    address = 0x44000004;
    jtag.writeMemory(address, value);
    //core is running......


    int* ro_readings = new int [70]; //0-63: Oscillator (DDRO), 64-65: SRAM/Core Power, 66-69: Leakage
    master_write();
    master_read(ro_readings);

    if( some GPIO != 0) {powerDown();}
}
*/

int main()
{
    s.printf("DDRO_software starts ...\r\n");
    double voltage = 1;
    PLL clk;
    JTAG jtag;
    int* ro_readings = new int [68];
#ifdef FILE_OUTPUT
    FILE *outFile = fopen("/local/test.out", "a");
#endif
    for (int i=0; i<1; i++) {
        voltage = 1 - 0.05*i;
        powerReset();
        powerUp(voltage);
#ifdef FILE_OUTPUT
        fprintf(outFile, "Voltage: %f\n", voltage);
#endif
        RESET = 0;
        wait_us(10);
        RESET = 1;
        for(int iii=0; iii<1; iii++) {
            master_write();
            master_read(ro_readings);
            for (int ii=0; ii<64; ii++) {
#ifdef FILE_OUTPUT
                fprintf(outFile, "RO %d %d\n", ii, ro_readings[ii]);
#endif
            }
            double core_meas = 3.3*ro_readings[64]/0x10000;
            double sram_meas = 3.3*ro_readings[65]/0x10000;
#ifdef FILE_OUTPUT
            fprintf(outFile, "CORE %f\nSRAM %f\n", core_meas,sram_meas);
#endif
            double hvtp_meas = 1.8*0.33/ro_readings[66]/0.001;
            double hvtn_meas = 1.5*0.33/ro_readings[67]/0.001;
#ifdef FILE_OUTPUT
            fprintf(outFile, "HVTP %f\nHVTN %f\n", hvtp_meas, hvtn_meas);
#endif
        }
        int fmax;
        int lower = 51;
        int higher = 199;
        int frequency = (lower+higher)/2;
        clk.setPLL(frequency);
        clk.setPLL(frequency);
        RESET = 0;
        wait_us(10);
        RESET = 1;

        while (higher - lower >1) {
            s.printf("testing %d\n", frequency);
            if(jtag.JTAG_test()) {
                lower = frequency;
                frequency = (lower+higher)/2;
                clk.setPLL(frequency);
                clk.setPLL(frequency);
                RESET = 0;
                wait_us(10);
                RESET = 1;
            } else {
                higher = frequency;
                frequency = (lower+higher)/2;
                clk.setPLL(frequency);
                clk.setPLL(frequency);
                RESET = 0;
                wait_us(10);
                RESET = 1;
            }
        }
        

#ifdef FILE_OUTPUT
        fprintf(outFile, "fmax %d\n", lower*5);
#endif
        powerDown();
    }
#ifdef FILE_OUTPUT
    fclose(outFile);
#endif
    s.printf("DDRO_software ends.\r\n");
    while(1) {
        finish_flag = !finish_flag;
        wait(1);
    }
}
