#include "mbed.h"
//input control for DDRO

Ticker CLK;

Serial pc(USBTX, USBRX); // tx, rx

DigitalOut ref_clk(p5);
DigitalOut count(p6);
DigitalOut read(p7);
DigitalOut enable(p8);
DigitalOut S0(p9);
DigitalOut S1(p10);
DigitalOut S2(p11);
DigitalOut S3(p12);
DigitalOut S4(p13);
DigitalOut S5(p14);
DigitalOut OS(p15);
DigitalIn FDO(p16);
DigitalIn O0(p21);
DigitalIn O1(p22);
DigitalIn O2(p23);
DigitalIn O3(p24);
DigitalIn O4(p25);
DigitalIn O5(p26);
DigitalIn O6(p27);
DigitalIn O7(p28);

void clk_gen()
{
    ref_clk = !ref_clk;
}

void assign_s(int selection)
{
    int remainder = selection;
    S0 = selection % 2;
    selection = selection / 2;
    S1 = selection % 2;
    selection = selection / 2;
    S2 = selection % 2;
    selection = selection / 2;
    S3 = selection % 2;
    selection = selection / 2;
    S4 = selection % 2;
    selection = selection / 2;
    S5 = selection % 2;
}

int read_out()
{
    int out;
    out = 0;
    OS = 1;
    out += O7.read();
    out *= 2;
    out += O6.read();
    out *= 2;
    out += O5.read();
    out *= 2;
    out += O4.read();
    out *= 2;
    out += O3.read();
    out *= 2;
    out += O2.read();
    out *= 2;
    out += O1.read();
    out *= 2;
    out += O0.read();
    out *= 2;
    OS = 0;
    wait(0.001);
    out += O7.read();
    out *= 2;
    out += O6.read();
    out *= 2;
    out += O5.read();
    out *= 2;
    out += O4.read();
    out *= 2;
    out += O3.read();
    out *= 2;
    out += O2.read();
    out *= 2;
    out += O1.read();
    out *= 2;
    out += O0.read();
    return out;
}

int main() {
  pc.printf("Testing Starts here\n");
  O0.mode(OpenDrain);
  O1.mode(OpenDrain);
  O2.mode(OpenDrain);
  O3.mode(OpenDrain);
  O4.mode(OpenDrain);
  O5.mode(OpenDrain);
  O6.mode(OpenDrain);
  O7.mode(OpenDrain);
  count = 0;
  read = 0;
  enable = 0;
  int i;
  for (i=0;i<64;i++)
  {
    //measure using 0.01
    int select = i;
    pc.printf("%d ", select);
    enable = 0;
    count = 0;
    read = 0;
    assign_s(select);
    CLK.attach(&clk_gen, 0.01);
    wait(0.1);
    enable = 1;
    count = 0;
    wait(0.001);
    count = 0;
    wait(0.001);
    count = 1;
    wait(0.001);
    count = 0;
    wait(0.1);
    read = 0;
    read = 1;
    read = 0;
    enable = 0;
    int out = read_out();
    pc.printf("%d ", out);
    OS = 1;
    wait(0.1);
    pc.printf("%d%d%d%d%d%d%d%d",O7.read(),O6.read(),O5.read(),O4.read(),O3.read(),O2.read(),O1.read(),O0.read());
    wait(0.1);
    OS = 0;
    pc.printf("%d%d%d%d%d%d%d%d ",O7.read(),O6.read(),O5.read(),O4.read(),O3.read(),O2.read(),O1.read(),O0.read());
    
    //measure using 0.1
    CLK.detach();
    enable = 0;
    count = 0;
    read = 0;
    CLK.attach(&clk_gen, 0.04);
    wait(0.2);
    enable = 1;
    count = 0;
    wait(0.001);
    count = 0;
    wait(0.001);
    count = 1;
    wait(0.001);
    count = 0;
    wait(0.2);
    read = 0;
    read = 1;
    read = 0;
    enable = 0;
    out = read_out();
    pc.printf("%d ", out);
    OS = 1;
    wait(0.1);
    pc.printf("%d%d%d%d%d%d%d%d",O7.read(),O6.read(),O5.read(),O4.read(),O3.read(),O2.read(),O1.read(),O0.read());
    wait(0.1);
    OS = 0;
    pc.printf("%d%d%d%d%d%d%d%d\n",O7.read(),O6.read(),O5.read(),O4.read(),O3.read(),O2.read(),O1.read(),O0.read());    
  }
}
