#include "mbed.h"
#include "C12832.h"

C12832 lcd(p5,p7,p6,p8,p11);
InterruptIn joystickcenter(p14);
InterruptIn button(p9);
DigitalOut led(LED1);
DigitalOut flash(LED4);
Timer debounce;
int i;

void flip()
{
    led = !led;
    if (debounce.read_ms()>1000) {
        i = 1;
        debounce.reset();
    }
}

int main()
{
    debounce.start();
    joystickcenter.rise(&flip);
    button.mode(PullUp);
    button.rise(&flip);
    while(1) {
        flash=!flash;
        wait (1);
        if(i==1) {
            lcd.locate(0,0);
            lcd.printf("flip function used %d", led.read());
            i=0;
            }
        }
}