#include "mbed.h"//preprocessor command 

Serial pc(USBTX,USBRX);//serial communication with teraterm via USBTX, USBRX

AnalogIn pot1(p19);//Analog pin associated with potentiometer 1
AnalogIn pot2(p20);//Analog pin associated with potentiometer 2
PwmOut red(p23);//Pulse width modulator(red)
PwmOut green(p24);//Pulse width modulator(green)
float pot1value;//float the value of pot1
float pot2value;//float the value of pot2

int main(){//main program
    while (1) {
        red = pot1;
        green = pot2;
        pot1value = pot1.read();
        pot2value = pot2.read();
        pc.printf("pot1 = %.3f   %.3fV | pot2 = %.3f   %.3fV\r", pot1value,
        pot1value*3.3, pot2value, pot2value*3.3);
        //shows the current value of the poteniometers in the range 0-1, 
        //also shows the voltage value
        
        wait (0.5); //wait half a second
    }
}
