// MBED driver for AD9850 digital synthesizer using hacked SPI interface
// Liam Goudge Sept 2013

#include "mbed.h"

SPI device (p5,p6,p7); // MOSI, MISO (not used), SCLK
DigitalOut CS(p8); // Use pin 8 as a fake Chip select
DigitalOut ADReset(p15); // Pin 15 is reset line for AD9850

Serial pc(USBTX, USBRX); // tx, rx for debug terminal

int reverseBits (int source)
{
// Unfortunately need to invert bit order of the desired frequency setting since MBED only allows for MSB first from SPI. We need LSB first for AD9850
    int mask=0;;
    int i=0;
    int target=0;
    int bitTarget=0x80000000; // Hard-wired for 32-bit inversion

    for (i=0;i<32;i++) { // ditto
        mask=1<<i;   
        bitTarget=1<<(31-i); // ditto

        if (source & mask)
            target=target | bitTarget;
    } 
    return target;
}    
     
void writeSPI(int frq, int phase)
{           
// Send the 40-bit packet. MBED only allows max 16-bit packets so we send 40-bits as 16, 16, 8
    device.format(16,0); // 16-bits per packet, mode 0 (CPOL=0 CPHA=0)
    device.frequency(1000000); //SPI clock set to 1MHz

    wait_ms(5);

    // First do chip select. Need to use a GPIO to fake the chip select since MBED doesn't allow to set positive logic CS signal
    CS=1; // assert chip select (a.k.a FQ_UD frequency update input to AD9850)
    wait_ms(5);
    CS=0;
        
    device.write(frq>>16); // Write upper 16-bits first starting with bit 31
    device.write(frq); // Now lower 16 bits starting with bit 15
    
    device.format(8,0); // Need to reset to 8-bit data since MBED only allows max 16-bit packets. For 40-bits we do 16, 16, 8
    device.write(phase); // This is phase and factory settings byte

    // Now pulse FQ_UD again to signal the end of the packet
    CS=0;
    wait_ms(5);
    CS=1;
    wait_ms(5);
    CS=0;
}
    

int main()
{
    int targetFrq=0x147AE148; // This is desired sine wave frequency for the AD9850, here set to 10MHz
    int increment=0x346DC6; // This is a 100KHz frequency increment

    // Reset the AD9850. Active high logic. Minimum reset period 5 clock cycles (5/125MHz)
    ADReset=0;
    wait_ms(5);
    ADReset=1;
    wait_ms(5);
    ADReset=0;
    
    while(1)
    {
    
    while (targetFrq<0x28F5C28F) // up to 20MHz
    {
        writeSPI(reverseBits(targetFrq),0); // Don't use phase so set to zero.
        targetFrq=targetFrq+increment;
        //wait_ms(100);
        }
        
    while (targetFrq>0x147AE148) // down to 10MHz
    {
        writeSPI(reverseBits(targetFrq),0);
        targetFrq=targetFrq-increment;
        //wait_ms(100);
        }  
    
    }      
        
        
}