#include "mbed.h"
#include "components.hpp"
#include "lglcd.h"
#include "time.h"
#include "stdio.h"
#define RED_DONE 1
#define YELLOW_DONE 2
//Digital outputs
DigitalIn onBoardSwitch(USER_BUTTON);
DigitalOut onBoardLED(LED1);
DigitalOut redLED(PE_15);
DigitalOut yellowLED(PB_10);
DigitalOut greenLED(PB_11);
SDBlockDevice sd(PB_5, D12, D13, D10);// miso, sclk, cs 
Mutex Lock1;
Mutex Lock2;
Mutex Remove;
//Inputs
time_t rawtime;
struct tm * timeinfo;
int year, month ,day, hour, minute, second;
char input = 0; 
char jtime[32];
char jdate[32];
char jdate1[32];
DigitalIn  SW1(PE_12);
DigitalIn  SW2(PE_14);
//Serial pc(USBTX, USBRX);
AnalogIn adcIn(PA_0);
//Environmental Sensor driver
#ifdef BME
BME280 sensor(D14, D15);
#else
BMP280 sensor(D14, D15);
#endif
lglcd mylcd(D7,D6,D5,D4,D3,D2);

//POWER ON SELF TEST
void post() 
{
    //posttest 
}
void runanalysis(void){
    while(1){     
Lock1.lock();
double temp = sensor.getTemperature();
double pressure = sensor.getPressure();
double lightin = adcIn;
char TEM[6];
char PRE[5];  
char LIGHT[6];
sprintf(TEM,"%.2f", temp);
sprintf(PRE,"%.2f", pressure);
sprintf(LIGHT,"%.2f", lightin);
mylcd.setline(1,1);
mylcd.write("L:");
if(lightin > 0.7 && lightin < 0.9)
{
mylcd.setline(1,4);
 mylcd.write("|||||||||MAX");    
}
else if(lightin > 0.55 && lightin < 0.69)
{
mylcd.setline(1,4);
 mylcd.write("|||||||     ");
}
else if(lightin > 0.5 && lightin < 0.54)
{
mylcd.setline(1,4);
 mylcd.write("|||||       ");
}
else if(lightin > 0.4 && lightin < 0.54)
{
mylcd.setline(1,4);
 mylcd.write("|||         ");
}
else if(lightin > 0.3 && lightin < 0.39)
{
mylcd.setline(1,4);
 mylcd.write("||          ");
} 
else if(lightin > 0.06 && lightin < 0.29)
{
mylcd.setline(1,4);
 mylcd.write("LOW LIGHT    ");
} 
else if(lightin < 0.05)
{
mylcd.setline(1,4);
mylcd.write("             ");
mylcd.setline(1,4);
mylcd.write("disconnected");
}
mylcd.setline(2,1);
mylcd.write("P:");
mylcd.write(PRE);
mylcd.setline(2,10);
mylcd.write("T:");
mylcd.write(TEM);
wait(0.01);
Lock1.unlock();
Thread::signal_wait(SIG_READY);
}
}
void sdwrite(void)
{
    while(1)
    {
        Lock2.lock();
time_t seconds = time(NULL);
char prefix[4];
char jdate2[32];
strcpy(prefix,"/sd/");
strftime(jdate1, 32, "%F", localtime(&seconds));
strftime(jdate, 32, "%F\n\r", localtime(&seconds));
strftime(jtime, 32, "%X\n\r", localtime(&seconds));
sprintf(jdate2,"%s%s",prefix,jdate1);
FATFileSystem fs("sd", &sd);
Lock1.lock();
double P = sensor.getPressure();
double L = adcIn;
double t = sensor.getTemperature();
char filename[32];
char suffix[4];
char tem[6];
char pre[5];  
char light[6];
char com[1];
strcpy(com, ",");
sprintf(pre,"%.2f", P);
sprintf(tem,"%.2f",t);
sprintf(light,"%.2f\n\r", L);

strcpy(suffix,".txt");
Lock1.unlock();
Lock1.lock();
sprintf(filename,"%s%s",jdate2,suffix);
Lock1.unlock();
//FILE* fp = fopen("/sd/test.txt","a");
FILE* fp = fopen(filename,"a");
    if (fp == NULL) {
        errorCode(FATAL);
        printf("SD FAIL\n\r");
        mylcd.clear();
        mylcd.setline(1,0);
        mylcd.write("SD FAIL");
    }
    if (fp != NULL){
    //printf("SD Success\n\r");
  //  fprintf(fp,"%s\n\r", "*C,  mbar,   light level 0-1 scale");
  char sdbuf[64];
  sprintf(sdbuf,"%s%s%s%s%s%s%s%s%s\n\r",jdate,com,jtime,com,pre,com,tem,com,light);
  fprintf(fp,"%s",sdbuf);
   // fprintf(fp,"%s",jdate);//date
//    fprintf(fp,"%s",com);
//    fprintf(fp,"%s",jtime);//time
//    fprintf(fp,"%s",com);
//    fprintf(fp,"%s",pre);
//    fprintf(fp,"%s",com);
//    fprintf(fp,"%s",tem);
//    fprintf(fp,"%s",com);
//    fprintf(fp,"%s\n\r",light);
    wait(0.01);
    }
      fclose(fp);      
      Lock2.unlock(); 
      Thread::signal_wait(SIG_READY2);   

}
}
void sdrun(void)
{
if ( sd.init() != 0) {
printf("Init failed\n\r");
mylcd.clear();
mylcd.setline(1,1);
mylcd.write("CANNOT INIT SD");        
errorCode(FATAL);
}
if( sd.init() == 0){
printf("Init Success \n\r");
mylcd.clear();
mylcd.setline(1,1);
mylcd.write("SD GOOD MAN");
wait(0.5); //flash the SD error / good code! 
}
}
void sdcheck(void){
if ( sd.init() != 0) {
printf("Init failed \n\r");
mylcd.clear();
mylcd.setline(1,1);
mylcd.write("CANNOT INIT SD\n\r");        
errorCode(FATAL);
}
if( sd.init() == 0){
//printf("SD Good\n\r");
}
}
void sdremove(void)
{
    while(1){
    Thread::signal_wait(SIG_REMOVE); 
    mylcd.clear();  
    Remove.lock();
                sd.deinit();
                mylcd.clear();
                Lock1.lock();
                mylcd.setline(2,0);
                greenLED = 1;
                mylcd.write("R");
                Lock1.unlock();
                printf("SD REMOVED\n\r");
                errorCode(FATAL);
    Remove.unlock();
}
}
void lcdstart(void){
    mylcd.clear();
    mylcd.setline(1,1);
    mylcd.write("INIT. SYSTEM");
    mylcd.setline(2,1);
    mylcd.write("ELEC351");
    }
void errorCode(ELEC350_ERROR_CODE err)
{
    switch (err) {
      case OK:
        greenLED = 1;
        wait(1.0);
        greenLED = 0;
        return;                
      case FATAL:
        while(1) {
            redLED = 1;
            wait(0.1);
            redLED = 0;
            wait(0.1);                
        }
    }
}

///dougs code

void DispTime(void)
{
    time_t Count = time(NULL);                      //Read the RTC Time
    printf("Current Time - %s\n\r", ctime(&Count)); //Print the current time
}

void setuptime(void)
{

    /*Initialising the time for our program to easy edit*/
    time ( &rawtime );
    timeinfo = localtime ( &rawtime );
    time ( &rawtime );
    timeinfo = localtime ( &rawtime );  
}

    void runtime(void){
    while(1) //When added to the main code this will be changed to a while "SETDATE"
    {  
            /*promts the user to input which edit they would like*/
            printf ("What part do you want to edit? Time(T)/All(A).\n\r"); 
            fflush(stdout); 
            scanf ("%s",&input);
            /*Switch case input*/
            switch(input)
            {
            case 'T':
                //Sequential Entering, Hour, Minute, Second respectively
                printf ("Enter hour:(00-23) \n\r"); 
                fflush(stdout); 
                scanf ("%d",&hour);

                printf ("Enter minute:(00-59) \n\r"); 
                fflush(stdout); 
                scanf ("%d",&minute);

                printf ("Enter second:(00-59) \n\r"); 
                fflush(stdout); 
                scanf ("%d",&second);
                
            break;
        
            /*Case A ----- All values Update sequence*/
            case 'A':
                printf ("Enter year:(0-9999) \n\r"); fflush(stdout); scanf ("%d",&year);
                printf ("Enter month:(01-12) \n\r"); fflush(stdout); scanf ("%d",&month);      
                printf ("Enter day:(01-31) \n\r"); fflush(stdout); scanf ("%d",&day);
                printf ("Enter hour:(00-23)\n\r"); fflush(stdout); scanf ("%d",&hour);
                printf ("Enter minute:(00-59) \n\r"); fflush(stdout); scanf ("%d",&minute);
                printf ("Enter second:(00-59) \n\r"); fflush(stdout); scanf ("%d",&second);
            break;
        
            /*default to reset ----- Month Update sequence*/
            default:
                printf  ("Invalid\n\r");
                set_time(1515513600);
        }  
        /*Updating all the timings after the user has input all the data*/
        /*Put here as once the user has finished editing it does a batch update*/
            timeinfo->tm_year = year - 1900;
            timeinfo->tm_mon = month - 1;
            timeinfo->tm_mday = day;
            timeinfo->tm_hour = hour;
            timeinfo->tm_min = minute;
            timeinfo->tm_sec = second;
            time_t CurrTime = mktime(timeinfo); //Convert the to UNIX time
            set_time(CurrTime);                 //Sets time using the UNIX time
            DispTime();  
            return;                       //Display the new time
        }
    }

void rundate(void){
    while(1) //When added to the main code this will be changed to a while "SETDATE"
    {
    
            /*promts the user to input which edit they would like*/
            printf ("What part do you want to edit? Date(D)/All(A).\n\r"); 
            fflush(stdout); 
            scanf ("%s",&input);
            /*Switch case input*/
            switch(input)
            {
            /*Case D ----- Date Update sequence*/  
            case 'D': 
                //Sequential Entering, Day, Month, Year respectively 
                printf ("Enter day:(01-31) \n\r"); 
                fflush(stdout); 
                scanf ("%d",&day); 
                printf ("Enter month:(01-12) \n\r"); 
                fflush(stdout); 
                scanf ("%d",&month);
                printf ("Enter year:(1970-9999) \n\r"); 
                fflush(stdout); 
                scanf ("%d",&year);                       
            break;    
            /*Case A ----- All values Update sequence*/
            case 'A':
                printf ("Enter year:(0-9999) \n\r"); fflush(stdout); scanf ("%d",&year);
                printf ("Enter month:(01-12) \n\r"); fflush(stdout); scanf ("%d",&month);      
                printf ("Enter day:(01-31) \n\r"); fflush(stdout); scanf ("%d",&day);
                printf ("Enter hour:(00-23)\n\r"); fflush(stdout); scanf ("%d",&hour);
                printf ("Enter minute:(00-59) \n\r"); fflush(stdout); scanf ("%d",&minute);
                printf ("Enter second:(00-59) \n\r"); fflush(stdout); scanf ("%d",&second);
            break;
            /*default to reset ----- Month Update sequence*/
            default:
                printf  ("Invalid\n\r");
                set_time(1515513600);
        }  
        /*Updating all the timings after the user has input all the data*/
        /*Put here as once the user has finished editing it does a batch update*/
            timeinfo->tm_year = year - 1900;
            timeinfo->tm_mon = month - 1;
            timeinfo->tm_mday = day;
            timeinfo->tm_hour = hour;
            timeinfo->tm_min = minute;
            timeinfo->tm_sec = second;
            time_t CurrTime = mktime(timeinfo); //Convert the to UNIX time
            set_time(CurrTime);                 //Sets time using the UNIX time
            DispTime();  
            return;                       //Display the new time
        }
    }