/*   ELEC351 COURSEWORK 2018 
DESIGNED USING MBED ONLINE COMPILER IMPORTED TO KEIL
LIAM GRAZIER // DOUG TILLEY // ALEX BARON 
 */
#include "mbed.h"
#include "lglcd.h"
lglcd::lglcd(PinName RS, PinName E, PinName D4, PinName D5,PinName D6, PinName D7) : _lcdrs(RS),_lcde(E), _lcdinfo(D4, D5, D6, D7)
{
       _lcde=1;              //clear enable
    _lcdrs=0;             // command
    writedata(_lcde,CMD);
    wait(0.000004);              
    writedata(0x28,CMD);         
    wait(0.000004);
    writedata(0x0C,CMD);      //turnoncursor and blink
    wait(0.000004);
    writedata(0x10,CMD);
    wait(0.000004);
    LCD_CLR;                 //clearlcd
    wait(0.000004);
    writedata(0x06,CMD);     //movecursor right
    wait(0.000004);
    LCD_HOME;               //Return to the 0,0 
}
void lglcd::clear(void)//lcd clear command with a tiny wait to ensure commadn finishes 
{
    LCD_CLR;             //clearcommandwitha small wait
    wait(0.002); 
}
void lglcd::setline(int row,int column) //set lu=ine and column function
{   
    if(row == 1) 
    { 
        writedata(LINE1|column,CMD);  //line1 included 
        wait(0.005); 
    }
    if(row == 2)
    {
        writedata(LINE2|column,CMD); 
        wait(0.005); 
    }
}
void lglcd::writedata(unsigned char data, unsigned char type) //manual write data wherever the pointer is , requires the line to be set first .
{
    if(type == CMD) 
    {
        _lcdrs=0;          //COMMAND MODE
    }
    else
    {
        _lcdrs=1;          //CHARACTER/DATA MODE
    } 
    _lcdinfo = data >> 4;
    wait(0.000050f); 
    _lcde = 0;
    wait(0.000050f);
    _lcde = 1;
    _lcdinfo = data >> 0;
    wait(0.000050f);
    _lcde = 0;
    wait(0.000050f);
    _lcde = 1;
}
void lglcd::write(char charq[]) //write character, not used, used writedata mainly, this works well if need to write along string to 2 lines (FOR LOOP FOR CHANING LINE AUTO) 
{ 
    for (int n = 0; n < strlen(charq); n++)
    {
        int count = 0;
        count++;
        writedata(charq[n], TXT);
        if (n == 15)
        {
            writedata(LINE2 | 0, CMD);
        }
        if (n == 32) 
        {
            clear();
            writedata(LINE1, CMD);
        }
    }   
}
