#ifndef __LGLCD_H
#define __LGLCD_H

#define CMD          0
#define TXT          1
#define CLEAR        1
#define HOME         2
#define READ         1
#define WRITE    0
#define LEFT         0
#define RIGHT    1

#define LINE1    0x80        // Start address of first line
#define LINE2    0xC0        // Start address of second line

#define LCD_CLR             (writedata(CLEAR,CMD))
#define LCD_HOME            (writedata(HOME,CMD))
#define LCD_BUSYBIT 0x8000  //correct value for the lcd BUSYBIT


class lglcd
{
public:
lglcd(PinName rs, PinName e, PinName d4, PinName d5,PinName d6, PinName d7);
void clear(void);
void writedata(unsigned char info, unsigned char type);
void write(char charq[]);
int l;
protected:
BusOut _lcdinfo;
DigitalOut _lcdrs;
DigitalOut _lcde;
int cline;
int cpos;
};
#endif