#include "mbed.h"
#include "lglcd.h"

lglcd::lglcd(PinName rs, PinName e, PinName d4, PinName d5,PinName d6, PinName d7) : _lcdrs(rs),_lcde(e), _lcdinfo(d4, d5, d6, d7)
{
    cline=1; //set the current line to the top line
    cpos=0; //sets the current position to the left most CHARACTER
    _lcde=1;              //clear enable
    _lcdrs=0;             // command
    l = 0;
    writedata(_lcde,CMD);
    wait(0.000004);              //delay for LCD to initialise.
    writedata(0x28,CMD);         //set to 4 bit interface, 2 line and 5*8 font
    wait(0.000004);
    writedata(0x0C,CMD);         //cursor on, cursor position blink
    wait(0.000004);
    writedata(0x10,CMD);
    wait(0.000004);
    LCD_CLR;                        //clear display
    wait(0.000004);
    writedata(0x06,CMD);         //move cursor right after write
    wait(0.000004);
    LCD_HOME;                                   //return home

}
/*---------------------------------------------------------------------*/
void lglcd::clear(void)//set a function to clear the lcd since just calling LCD_CLR can throw error if called to quickly
{
    LCD_CLR;
    wait(0.002); //2ms delay to stop timing error
}

/*---------------------------------------------------------------------*/
void lglcd::writedata(unsigned char info, unsigned char type)
{
    if(type == CMD) {
        _lcdrs=0;              //COMMAND MODE
    } else {
        _lcdrs=1;          //CHARACTER/DATA MODE
    }
    
    _lcdinfo = info >> 4;
    wait(0.000040f); // most instructions take 40us
    _lcde = 0;
    wait(0.000040f);
    _lcde = 1;
    _lcdinfo = info >> 0;
    wait(0.000040f);
    _lcde = 0;
    wait(0.000040f);  // most instructions take 40us
    _lcde = 1;
}

void lglcd::write(char charq[])
{ 
 for (int i = 0; i < strlen(charq); i++)
  {
    wait(0.003);
    int count = 0;
    count++;
    writedata(charq[i], TXT);
    if (i == 15) {
      writedata(LINE2 | 0, CMD);
    }
    if (i == 32) {
      clear();
      writedata(LINE1, CMD);
   }
  }
}
