/*   ELEC351 COURSEWORK 2018 
DESIGNED USING MBED ONLINE COMPILER IMPORTED TO KEIL
LIAM GRAZIER // DOUG TILLEY // ALEX BARON 
 */
#include "mbed.h"
#include "stx.hpp"
#include "components.hpp"
Mutex Sx; //mutex lock for serial tx (Sx) Thread
char buffer[255]; //buffer used for storing scanf data from serial rx
int empty = 0; //empty flag
void welcomemsg(void) //function for welcome msg for the main.
{
    printf("WELCOME TO ELEC351 ENVIRONMENTAL SERIAL INTERFACE\n\rFOR ASSISTANCE TYPE HELP\n\r"); //msg that is printed
}
void datain(void) //function for scaning the serial rx input and writing to the Char Buffer 
{
    if(empty == 0)
    {
        Sx.lock(); //locks to protect the scan
        scanf("%s", &buffer);
        Sx.unlock();
    }
}
void printcommandlist() //function for printing the command list to the terminal
{
    Sx.lock();
    printf("Command List:\n\r READALL\n\r DELETEALL\n\r SETDATE\n\r DISPLAYTIME\n\r SETTIME\n\r SETT\n\r STATEON(Sampling State)\n\r STATEOFF(Sampling State)\n\r LOGGINGON\n\r LOGGINGOFF\n\r COMMANDLIST\n\r" );
    Sx.unlock();
}
void readdata() //function for deciding what to do with the data in the buffer
{
    if (buffer != "")
    {
        if (strstr(buffer, "READALL"))
        {
            printf("COMMAND NOT AVAILABLE\n\r");//command not coded yet
        }
        else if(strstr(buffer, "COMMANDLIST")) //prints command list to terminal
        {
            printcommandlist();   
        }
        else if(strstr(buffer, "DISPLAYTIME")) //displays current RTC time via command 
        {
            DispTime();  
        }
        else if(strstr(buffer, "HELP")) //calls help command 
        {
            help();   
        }
        else if(strstr(buffer, "DELETEALL"))//calls delete all records (working)
        {
            deletealldata();
        }
        else if(strstr(buffer, "SETDATE")) //calls set date function (working)
        {
            rundate();
        }
        else if(strstr(buffer, "SETTIME")) //calls set time function (WORKING)
        {
            runtime();
        }
        else if(strstr(buffer, "SETT"))
        {
            printf("ENTER SAMPLING RATE RANGLE 0.1<T<60\n\r");
            printf("COMMAND NOT AVAILABLE\n\r"); //command not coded yet
        }
        else if(strstr(buffer, "STATEON"))
        {
            printf("COMMAND NOT AVAILABLE\n\r"); //command not coded yet
        }
            else if(strstr(buffer, "STATEOFF"))
        {
            printf("COMMAND NOT AVAILABLE\n\r"); //command not coded yet
        }
        else if(strstr(buffer, "LOGGINGON"))
        {
            printf("IF YOU ARE SEEING THIS, NO ISSUES"); //command not coded yet, just a bit of a joke
        }
        else if(strstr(buffer, "LOGGINGOFF"))
        {
            printf("COMMAND NOT AVAILABLE\n\r"); //command not coded yet
        }
        else
        {
            printf("UNRECOGNISED\n\r"); //returns unrecognised for all comments not matching criteria above
        }
    }
}
void help() //help command 
{
    printf("HELP: \n\rFOR COMMAND LIST, type COMMANDLIST\n\r"); //prints this statement when HELP is typed
}    
void readalldata() //command not coded (placeholder for code to be called from
{
    printf("read all data\n\r");
} 
void deletealldata()//commadn for wiping the SD (WORKING)
{
    sdwipe();
}
void setT()//command not coded (placeholder for code to be called from
{
    printf("Set Sampling Period 'T'\n\r");
} 
void stateon()//command not coded (placeholder for code to be called from
{
    printf("Set Sampling ON\n\r");
} 
void stateoff()//command not coded (placeholder for code to be called from
{
    printf("Set Sampling OFF\n\r");
} 
void loggingon()//command not coded (placeholder for code to be called from
{
printf("Logging On\n\r");
} 
void loggingoff() //command not coded (placeholder for code to be called from
{
printf("Logging Off\n\r");
}    
void useseriel()
{
    help(); //prints the help command when serial init. (this prints in terminal)
    while(true)
    {
        Thread::signal_wait(SIG_SX); //this signal triggers on ticker from main
        datain(); //getdata
        readdata(); //readata and decide what to do with it 
    }
}   
