/*   ELEC351 COURSEWORK 2018 
DESIGNED USING MBED ONLINE COMPILER IMPORTED TO KEIL
LIAM GRAZIER // DOUG TILLEY // ALEX BARON 
 */
#include "components.hpp"
#include "mbed.h"
#include "network.hpp"
#include "lglcd.h"
#include "stx.hpp"
//voids for ticker attached tasks 
void inter1();
void inter2();
void inter3();
void inter4();
void inter5();
//thread initalised with priorities 
Thread samplesThread(osPriorityNormal);
Thread sdThread(osPriorityHigh);
Thread sdRemoveThread(osPriorityHigh);
Thread timebuttonThread(osPriorityNormal);
Thread stxThread(osPriorityLow);
Thread netThread(osPriorityRealtime);
//interrupt assign 
InterruptIn sdex(USER_BUTTON);
//ticker assigns 
Ticker samples;
Ticker remov;
Ticker storage;
Ticker netTick;
Ticker serielTick;
//sd card attached signal flag task
void inter1()
{
    sdcheck();
    samplesThread.signal_set(SIG_READY);          
}
//sampling attached signal flag task
void inter2()
{
    sdThread.signal_set(SIG_READY2);  
}
//sd card remove attached signal flag task
void inter3()
{
    if(sdex == 1)//checks if remove button *USER BUTTON triggered by interrupt has been flagged to indicated remove
    {
        sdRemoveThread.signal_set(SIG_REMOVE);
    }
}
//network attached signal flag task
void inter4()
{
    netThread.signal_set(SIG_NET);
}
//setial comms attached signal flag task
void inter5()
{
    stxThread.signal_set(SIG_SX);
}
int main()
{
    lglcd mylcd(D7,D6,D5,D4,D3,D2);//setup lcd
    setuptime();//setup time to default 
    sdrun(); //init sd
    lcdstart();//run lcd start code
    welcomemsg(); //display welcome msg in the terminal 
    sdThread.start(sdwrite); 
    storage.attach(&inter2,1); //attached the storage SD ticker to the allocated flag task, this triggers every 1secs
    samplesThread.start(runanalysis); 
    samples.attach(&inter1,1);   //attached the samples ticker  to the allocated flag task, this triggers every 1secs
    sdRemoveThread.start(sdremove);
    remov.attach(&inter3,3);//attached the SD Remove ticker  to the allocated flag task, this triggers every 3secs
    netThread.start(networksend);
    netTick.attach(&inter4,0.01);//attached the network ticker to the allocated flag task, this triggers every 0.01secs
    stxThread.start(useseriel);//
    serielTick.attach(&inter5,0.1);//attached the serial ticker to the allocated flag task, this triggers every 0.1secs
}