#if !FEATURE_LWIP
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif
#include "mbed.h"
#include "EthernetInterface.h"
#include "TCPServer.h"
#include "TCPSocket.h"
 char realtime[32];
#include <iostream>
#include <string> 
#include "BMP280.h"
#include "components.hpp"
#include "network.hpp"
Mutex Net;
#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY1 ""                                    \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Sensor Data</h1>" "\r\n"                              \
"      <p>Light Level LDR value: " "\r\n" 
                 
#define HTTP_Pressure1 ""                                        \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1> </h1>" "\r\n"                                        \
"      <p>Pressure(mbar): " "\r\n"                

#define HTTP_Pressure2 ""                                        \
       "</p>" "\r\n"                                             \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"
#define HTTP_TIME ""                                     \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1> </h1>" "\r\n"                                        \
"      <p>Time: " "\r\n"       
                 
#define HTTP_Temperature1 ""                                     \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1> </h1>" "\r\n"                                        \
"      <p>Temperature(Degrees Celcius): " "\r\n"       

#define HTTP_Temperature2 ""                                     \
       "</p>" "\r\n"                                             \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"
#define HTTP_MESSAGE_TIME ""                                    \
       "</p>" "\r\n"                                             \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"
#define HTTP_MESSAGE_BODY2 ""                                    \
       "</p>" "\r\n"                                             \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"


#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

#define IP        "10.0.0.10"
#define NETMASK   "255.0.0.0"
#define GATEWAY   "10.0.0.1"
void dispstralltime(){
    time_t seconds = time(NULL);
    strftime(realtime, 32, "%c\n\r", localtime(&seconds));
   }
void networksend(void)
{   
    // interrupt routine setup
    Net.lock();
    printf("Network Enabled\n\r");//n
    //Configure an ethernet connection
    EthernetInterface eth;
    eth.set_network(IP, NETMASK, GATEWAY);
    eth.connect();
//
    Net.unlock();
    //Now setup a web server
    TCPServer srv;           //TCP/IP Server
    TCPSocket clt_sock;      //Socket for communication
    SocketAddress clt_addr;  //Address of incoming connection
    
    /* Open the server on ethernet stack */
    srv.open(&eth);
    
    /* Bind the HTTP port (TCP 80) to the server */
    srv.bind(eth.get_ip_address(), 80);
    
    /* Can handle 5 simultaneous connections */
    srv.listen(5);
    
    while (true) {
        Net.lock();
        using namespace std;
        //Block and wait on an incoming connection
        srv.accept(&clt_sock, &clt_addr);
//        printf("accept %s:%d\n", clt_addr.get_ip_address(), clt_addr.get_port());
        
        double temp = sensor.getTemperature();
        double pres = sensor.getPressure();
        //Uses a C++ string to make it easier to concatinate
        string response;
        //This is a C string
        char adcIn_str[64];
        char pres_str[64];
        char temp_str[64];
        dispstralltime();              
        //Read the LDR value
        float u = adcIn;
        float b = pres;
        float a = temp;
        
        //Convert to a C String
        sprintf(adcIn_str, "%5.3f", u );
        sprintf(pres_str, "%4.2f", b);
        sprintf(temp_str, "%3.1f", a);
        
        //Build the C++ string response
        response += HTTP_TIME;
        response += realtime;
        response += HTTP_MESSAGE_BODY1;
        response += adcIn_str;
        response += HTTP_Temperature1;
        response += temp_str;
        response += HTTP_Temperature2;
        response += HTTP_Pressure1;
        response += pres_str;
        response += HTTP_Pressure2;
        response += HTTP_MESSAGE_TIME;
        response += HTTP_MESSAGE_BODY2;       
        //Send static HTML response (as a C string)
        clt_sock.send(response.c_str(), response.size()+6); 
        Net.unlock();   
        Thread::signal_wait(SIG_NET);
    }
}
