#include "mbed.h"
#include "TextLCD.h"

//#define BME
#ifdef BME
#include "BME280.h"
#else
#include "BMP280.h"
#endif

//LCD Driver
//RS D9
//E  D8
//D7,6,4,2 are the 4 bit for d4-7
TextLCD lcd(D9, D8, D7, D6, D4, D2); // rs, e, d4-d7

//Sensor driver
#ifdef BME
BME280 sensor(D14, D15);
#else
BMP280 sensor(D14, D15);
#endif

int main() {
        
    while(1) {
        double temp = sensor.getTemperature();
        double pressure = sensor.getPressure();
        lcd.printf("Temp   Pressure\n"); 
        lcd.printf("%6.1f ",temp);
        lcd.printf("%.2f\n",pressure);
        wait(2.0);
    }
}

