#include "mbed.h"
#include "components.hpp"
#include "lglcd.h"
#include "stdio.h"
#define RED_DONE 1
#define YELLOW_DONE 2
//Digital outputs
DigitalIn onBoardSwitch(USER_BUTTON);
DigitalOut onBoardLED(LED1);
DigitalOut redLED(PE_15);
DigitalOut yellowLED(PB_10);
DigitalOut greenLED(PB_11);
SDBlockDevice sd(PB_5, D12, D13, D10);// miso, sclk, cs 
Mutex Lock1;
Mutex Lock2;
Mutex Remove;
//Inputs

DigitalIn  SW1(PE_12);
DigitalIn  SW2(PE_14);
//Serial pc(USBTX, USBRX);
AnalogIn adcIn(PA_0);

//Environmental Sensor driver
#ifdef BME
BME280 sensor(D14, D15);
#else
BMP280 sensor(D14, D15);
#endif
lglcd mylcd(D7,D6,D5,D4,D3,D2);

//POWER ON SELF TEST
void post() 
{
    //posttest 
}
void runanalysis(void){
    while(1){     
Lock1.lock();
double temp = sensor.getTemperature();
double pressure = sensor.getPressure();
double lightin = adcIn;
char TEM[6];
char PRE[5];  
char LIGHT[6];
printf("REFRESH SENSORS\n\r");
sprintf(TEM,"%.2f", temp);
sprintf(PRE,"%.2f", pressure);
sprintf(LIGHT,"%.2f", lightin);
mylcd.setline(1,1);
mylcd.write("L:");
if(lightin > 0.7 && lightin < 0.9)
{
mylcd.setline(1,4);
 mylcd.write("|||||||||MAX");    
}
else if(lightin > 0.55 && lightin < 0.69)
{
mylcd.setline(1,4);
 mylcd.write("|||||||     ");
}
else if(lightin > 0.5 && lightin < 0.54)
{
mylcd.setline(1,4);
 mylcd.write("|||||       ");
}
else if(lightin > 0.4 && lightin < 0.54)
{
mylcd.setline(1,4);
 mylcd.write("|||         ");
}
else if(lightin > 0.3 && lightin < 0.39)
{
mylcd.setline(1,4);
 mylcd.write("||          ");
} 
else if(lightin > 0.06 && lightin < 0.29)
{
mylcd.setline(1,4);
 mylcd.write("LOW LIGHT    ");
} 
else if(lightin < 0.05)
{
mylcd.setline(1,4);
mylcd.write("             ");
mylcd.setline(1,4);
mylcd.write("disconnected");
}
mylcd.setline(2,1);
mylcd.write("P:");
mylcd.write(PRE);
mylcd.setline(2,10);
mylcd.write("T:");
mylcd.write(TEM);
wait(0.01);
Lock1.unlock();
Thread::signal_wait(SIG_READY);
}
}
void sdwrite(void)
{
    while(1)
    {
        Lock2.lock();
        FATFileSystem fs("sd", &sd);
FILE* fp = fopen("/sd/test.csv","a");
    if (fp == NULL) {
        errorCode(FATAL);
        printf("SD FAIL\n\r");
        mylcd.clear();
        mylcd.setline(1,0);
        mylcd.write("SD FAIL");
    }
    if (fp != NULL){
    printf("SD Success\n\r");
    fprintf(fp, "hello,hello,hello\n\r");
    wait(0.01);
    }
      fclose(fp);      
      Lock2.unlock(); 
      Thread::signal_wait(SIG_READY2);   

}
}
void sdrun(void)
{
if ( sd.init() != 0) {
printf("Init failed \n");
mylcd.clear();
mylcd.setline(1,1);
mylcd.write("CANNOT INIT SD");        
errorCode(FATAL);
}
if( sd.init() == 0){
printf("Init Success \n");
mylcd.clear();
mylcd.setline(1,1);
mylcd.write("SD GOOD MAN");
wait(0.5); //flash the SD error / good code! 
}
}
void sdcheck(void){
if ( sd.init() != 0) {
printf("Init failed \n\r");
mylcd.clear();
mylcd.setline(1,1);
mylcd.write("CANNOT INIT SD\n\r");        
errorCode(FATAL);
}
if( sd.init() == 0){
printf("SD Good\n\r");
}
}
void sdremove(void)
{
    Thread::signal_wait(SIG_REMOVE); 
    mylcd.clear();  
    Remove.lock();
                sd.deinit();
                mylcd.clear();
                mylcd.setline(1,0);
                greenLED = 1;
                mylcd.write("R");
                printf("SD REMOVED");
                errorCode(FATAL);
    Remove.unlock();
}
void errorCode(ELEC350_ERROR_CODE err)
{
    switch (err) {
      case OK:
        greenLED = 1;
        wait(1.0);
        greenLED = 0;
        return;                
      case FATAL:
        while(1) {
            redLED = 1;
            wait(0.1);
            redLED = 0;
            wait(0.1);                
        }
    };
}