/********************************** include *********************************/
#include "mbed.h"
#include "start.h"
#include "lcd.h"


InterruptIn button_a(p29);
InterruptIn button_b(p28);
InterruptIn button_d(p26);
InterruptIn button_c(p27);
DigitalOut led(LED1);

Ticker flipper;
int button_a_flag;
int button_b_flag;
int button_d_flag;
int button_c_flag;
DigitalOut led1(LED1);

void buttonA_isr();
void buttonB_isr();
void buttonC_isr();
void buttonD_isr();

void rise_A();
void rise_B();
void rise_C();
void rise_D();

int main()
{
    button_a_flag = 0;
    button_b_flag = 0;
    button_c_flag = 0;
    button_d_flag = 0;
    rise_A();
    rise_B();
    rise_C();
    rise_D();


    //select(volatile int button_a_flag,volatile int button_d_flag,volatile int button_b_flag);
    while(1) {
        lcd_init();
        lcd_clear();
        print_menu();
        lcd_refresh();
        if (button_c_flag) {
            button_c_flag = 0;
            led1 = !led1;
            select11(&button_a_flag,&button_d_flag,&button_b_flag);
        }

    }

}

void buttonA_isr()
{
    button_a_flag = 1;   // set flag in ISR
}
void buttonB_isr()
{
    button_b_flag = 1;   // set flag in ISR
    
}
void buttonC_isr()
{
    button_c_flag = 1;   // set flag in ISR
}
void buttonD_isr()
{
    button_d_flag = 1;   // set flag in ISR
}
void rise_A()
{
    button_a.rise(&buttonA_isr);//检测上升沿
    button_a.mode(PullNone);
}
void rise_B()
{
    button_b.rise(&buttonB_isr);//检测上升沿
    button_b.mode(PullNone);
}
void rise_C()
{
    button_c.rise(&buttonC_isr);//检测上升沿
    button_c.mode(PullNone);
}

void rise_D()
{
    button_d.rise(&buttonD_isr);//检测上升沿
    button_d.mode(PullNone);
}


