/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "C12832.h"
C12832 lcd(D11, D13, D12, D7, D10);

PwmOut r (D5);
PwmOut g (D9);
PwmOut b (D8);

AnalogIn pot1 (A0);
AnalogIn pot2 (A1);

int main()
{
    
    while(true)
    {
        float v1 = pot1.read();
        float v2 = pot2.read();
        r.write(v1);
        g.write(v2);
        b.write(v1);
        
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Pot1 value: %.2f",v1);
        lcd.locate(0,15);
        lcd.printf("Pot2 value: %.2f",v2);
        wait(1.0);
    }    
}

