#include "mbed.h"          // MBED LIBRARY
#include "MODSERIAL.h"     // MBED BUFFERED SERIAL

#include "UM6_usart.h"     // UM6 USART HEADER
#include "UM6_config.h"    // UM6 CONFIG HEADER

/////////////////////////////////////////////////////////////////////////////////////////////
// SETUP (ASSIGN) SERIAL COMMUNICATION PINS ON MBED
/////////////////////////////////////////////////////////////////////////////////////////////
MODSERIAL pc(USBTX, USBRX);  // PC SERIAL OVER USB PORT ON MBED

////////////////////////////////////////////////////////////////////////////////////////////////
// SETUP (ASSIGN) MBED LED (1 thru 3) FOR VISUAL DEBUGGING ON MBED
////////////////////////////////////////////////////////////////////////////////////////////////
DigitalOut pc_activity(LED1);    // LED1 = PC SERIAL
DigitalOut uart_activity(LED2);  // LED2 = UM6 SERIAL


void rxCallback(MODSERIAL_IRQ_INFO *q) {
    if (um6_uart.rxBufferGetCount() >=  MAX_PACKET_DATA) {
        uart_activity = !uart_activity;  // Lights LED when uart RxBuff has > 40 bytes
        Process_um6_packet();
    }
}
 

int main() {

/////////////////////////////////////////////////////////////////////////////////////////////////////
//          SET SERIAL UART BAUD RATES
/////////////////////////////////////////////////////////////////////////////////////////////////////

    // set UM6 serial uart baud 9600
    um6_uart.baud(9600);
    pc.baud(9600);  // pc baud for UM6 to pc interface

    // attach interupt function to uart
    um6_uart.attach(&rxCallback, MODSERIAL::RxIrq);

    int Roll_Counter = 0;

    while (1) {
         Roll_Counter++;      
         if (Roll_Counter > 5000000) {
          pc.printf("Gyro_Proc_X %f deg/s, ",data.Gyro_Proc_X);
          pc.printf("Gyro_Proc_Y %f deg/s, ",data.Gyro_Proc_Y);
          pc.printf("Gyro_Proc_Z %f deg/s, ",data.Gyro_Proc_Z);
          pc.printf("Roll %f deg, ",data.Roll);
          pc.printf("Pitch %f deg, ",data.Pitch);
          pc.printf("Yaw %f deg \r\n",data.Yaw);
          pc_activity = !pc_activity;  // Lights LED when uart RxBuff has > 40 bytes
          Roll_Counter = 0;
         }
  
    }  // end while(1) loop

}  // end main()