#include "mbed.h"

// Loads watchdog timer with TC value
void feed() {
    LPC_WWDT->FEED = 0xAA;
    LPC_WWDT->FEED = 0x55;
}

// Ref. UM10462.pdf chapter 17
void WDTInit() {
    // Power on interface...
    LPC_SYSCON->SYSAHBCLKCTRL |= (0x1 << 15);

    // Power on watchdog oscillator
    LPC_SYSCON->PDRUNCFG &= 0x3F;

    // Select watchdog oscillator for WWDT clock source
    LPC_WWDT->CLKSEL = 0x1;

    uint32_t clk = SystemCoreClock / 16;
    LPC_WWDT->TC = 0xfff;//10 * clk;

    // Enable WWDT. The timer will not begin until the
    // proper feed sequence is loaded.
    LPC_WWDT->MOD = 0x3;

    feed();
#if 0
    printf("CLKSEL->0x%x TC->0x%x MOD->0x%x FEED->0x%x\n", LPC_WWDT->CLKSEL, LPC_WWDT->TC, LPC_WWDT->MOD, LPC_WWDT->FEED);
    printf("clk->%d\n", clk);
#endif
}
