#include "mbed.h"
#define WHITE 0xFFFFFF
#include <stdlib.h>
#include <time.h>
#include "PinDetect.h"
#define NUM_DICE 6
#include "FarkleGame.h"

#include "uLCD_4DGL.h"

extern uLCD_4DGL uLCD;
void FarkleGame::changeDieArray()
{
    int rollable=0;//keep track of how many dice are in a rollable state

    for(int i=0; i<6; i++) { //determine which die are rollable and increment
        if(arr[i].getCurrDieState()==ROLL) {
            rollable+=1;
        }
    }
    if(rollable==6) { //these next if statements change the number of rollable die based on how many are currently rollable
        for(int i=0; i<6; i++) {
            (arr[i].setCurrDieState(REMOVED));
        }
    } else if(rollable==5)
        for(int i=0; i<6; i++) {
            if(arr[i].getCurrDieState()==REMOVED) {
                arr[i].setCurrDieState(ROLL);
            }
        } else if(rollable==4)
        for(int i=0; i<6; i++) {
            if(arr[i].getCurrDieState()==REMOVED) {
                arr[i].setCurrDieState(ROLL);
                break;
            }
        } else if(rollable==3)
        for(int i=0; i<6; i++) {
            if(arr[i].getCurrDieState()==REMOVED) {
                arr[i].setCurrDieState(ROLL);
                break;
            }
        } else if(rollable==2)
        for(int i=0; i<6; i++) {
            if(arr[i].getCurrDieState()==REMOVED) {
                arr[i].setCurrDieState(ROLL);
                break;
            }
        } else if(rollable==1)
        for(int i=0; i<6; i++) {
            if(arr[i].getCurrDieState()==REMOVED) {
                arr[i].setCurrDieState(ROLL);
                break;
            }
        } else if(rollable==0)
        for(int i=0; i<6; i++) {
            if(arr[i].getCurrDieState()==REMOVED) {
                arr[i].setCurrDieState(ROLL);
                break;
            }
        }



}

void FarkleGame::printScore() //print score function
{
    uLCD.display_control(LANDSCAPE);
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.locate(0,1);
    uLCD.printf("Your\n");
    uLCD.printf("Turn\n");
    uLCD.printf("Score\n");
    uLCD.printf("------");
    uLCD.printf("\n%d", score);
}
Die* FarkleGame::getDieArray()//getter for die array
{
    return arr;
}

int FarkleGame::calcScore(int *numarray)
{
    int rollScore=0;//initialize rollScore to zero
    for(int i=1; i<7; i++) {
        if (numarray[i] == 6) {//search for 6 of a kind, code is very similar for 5 and 4 of a kind except for point difference
            rollScore += 3000;
            numarray[i]=0;
            for(int idx=0; i<6; i++) {
                arr[idx].setCurrDieState(REMOVED);//if the dice in the array are part of the score, remove them
            }
        }
        if (numarray[i] == 5) {
            rollScore += 2000;
            numarray[i]=0;
            for(int idx=0; i<6; i++) {
                if(arr[idx].getValue()==i) {
                    arr[idx].setCurrDieState(REMOVED);
                }
            }
        }
        if (numarray[i] == 4) {
            rollScore += 1000;
            numarray[i]=0;
            for(int idx=0; idx<6; idx++) {
                if(arr[idx].getValue()==i) {
                    arr[idx].setCurrDieState(REMOVED);
                }
            }
        }
    }
    int pairCounter=0;//need to count how many pairs and triples
    int tripCounter=0;
    int flushCounter=0;
    for(int i=1; i<7; i++) {//iterate to find pairs and triples

        if (numarray[i] == 3) {
            tripCounter+=1;
        }
        if (tripCounter==2) {
            rollScore+=2500;
            tripCounter=0;
            for(int i=0; i<7; i++) {//this function removes dice that score and resets so dice in triples don't score twice
                if(numarray[i]==3) {
                    numarray[i]=0;
                    for(int idx=0; idx<6; idx++) {
                        if(arr[idx].getValue()==i) {
                            arr[idx].setCurrDieState(REMOVED);
                        }
                    }
                }
            }
        }
        if (numarray[i] == 2) {
            pairCounter+=1;
        }
        if (pairCounter==3) {
            rollScore+=1500;
            pairCounter=0;
            for(int i=0; i<7; i++) {//extremely similar to the triple counter
                if(numarray[i]==2) {
                    numarray[i]=0;
                    for(int idx=0; idx<6; idx++) {
                        if(arr[idx].getValue()==i) {
                            arr[idx].setCurrDieState(REMOVED);
                        }
                    }
                }
            }
        }
        if (numarray[i]==1) {
            flushCounter+=1;
        }
        if (flushCounter==6) {//flush counter to determine if all parts of an array keeping track of numbers only have one number each
            rollScore+=1500;  //indicating one of each number was rolled (flush)
            for(int idx=0; idx<6; idx++) {
                arr[idx].setCurrDieState(REMOVED);//remove scoring die
            }
            flushCounter=0;


        }
    }
    if(tripCounter==1) {
        for(int idx=0; idx<7; idx++) {
            if(numarray[idx]==3) {//if there is only one triple, we add the corresponding number of points
                if(idx==1) {
                    rollScore+=1000;
                    for(int index=0; index<6; index++) {
                        if(arr[index].getValue()==idx) {
                            arr[index].setCurrDieState(REMOVED);//remove scoring die
                        }
                    }
                } else {
                    rollScore+=idx*100;
                    for(int index=0; index<6; index++) {
                        if(arr[index].getValue()==idx) {
                            arr[index].setCurrDieState(REMOVED);
                        }
                    }
                }
                numarray[idx]=0;
            }
        }
    }
    if(pairCounter!=3) {
        for(int idx=0; idx<7; idx++) {
            if(idx==1) {
                if(numarray[idx]==2) {
                    rollScore+=200;//if there are not three pairs, only add points for 1's and 5's
                    numarray[idx]=0;
                    for(int index=0; index<6; index++) {
                        if(arr[index].getValue()==idx) {
                            arr[index].setCurrDieState(REMOVED);
                        }
                    }
                }
                if(numarray[idx]==1) {
                    rollScore+=100;
                    numarray[idx]=0;
                    for(int index=0; index<6; index++) {
                        if(arr[index].getValue()==idx) {
                            arr[index].setCurrDieState(REMOVED);
                        }
                    }
                }

            }
            if(idx==5) {
                if(numarray[idx]==2) {
                    rollScore+=100;
                    numarray[idx]=0;
                    for(int index=0; index<6; index++) {
                        if(arr[index].getValue()==idx) {
                            arr[index].setCurrDieState(REMOVED);
                        }
                    }
                }
                if(numarray[idx]==1) {
                    rollScore+=50;
                    numarray[idx]=0;
                    for(int index=0; index<6; index++) {
                        if(arr[index].getValue()==idx) {
                            arr[index].setCurrDieState(REMOVED);
                        }
                    }
                }

            }
        }
        pairCounter=0;
    }
    return rollScore;
}













int FarkleGame::getScore()//setter and getter for score
{
    return score;
}

void FarkleGame::setScore(int num)
{
    score=num;
}
void FarkleGame::startGame()
{
    uLCD.cls();
    uLCD.display_control(LANDSCAPE);
    uLCD.text_width(2);
    uLCD.text_height(2);
    uLCD.locate(0,1);
    uLCD.printf("Shake\n");
    uLCD.printf("Board\n");
    uLCD.printf("------\n");
    uLCD.printf("To\n");
    uLCD.printf("Roll\n");
    int rolling=0;
    for(int i=0; i<6; i++) {
        if(arr[i].getCurrDieState()==ROLL) {//count how many die are in a rollable state and use that to display how many dice the user will roll
            rolling+=1;
        }
    }
    uLCD.printf("%d", rolling);
    uLCD.printf(" Dice");
}

