#include "mbed.h" 
#define WHITE 0xFFFFFF 
#include <stdlib.h>
#include <time.h>
#include "PinDetect.h"
#include "uLCD_4DGL.h"
#include "TMP36.h"
//#include "Die.h"
#include "FarkleGame.h"
#include "MMA8452.h"
#include <cmath>
#include "Speaker.h"
#include <sstream>
//------------------------Initial Declarations--------------------------------//
Speaker mySpeaker(p26);
PinDetect pb1(p25);
PinDetect pb2(p24);
PinDetect pb3(p23);
Serial pc(USBTX,USBRX);
MMA8452 acc(p28,p27,40000);
uLCD_4DGL uLCD(p9, p10, p11); 
TMP36 myTMP36(p15);
enum Inputs{buttonA,buttonB,buttonC,shake,none};
enum States{Initial,Display,Roll};
volatile Inputs input=none;
volatile States currState=Initial;

void pb1_pressed(void){
    input=buttonA;
    }
void pb2_pressed(void){
    input=buttonB;
    
    }
void pb3_pressed(void){
    input=buttonC;
    }
    
void setupAccelerometer(){
    acc.setBitDepth(MMA8452::BIT_DEPTH_12);
    acc.setDynamicRange(MMA8452::DYNAMIC_RANGE_4G);
    acc.setDataRate(MMA8452::RATE_100);
    }
    
    
//---------------------------------------------------------------------------//
int main() { 
    int seedAssist;
    seedAssist = static_cast <int> (10000*myTMP36.read())%12344;
    srand(time(0)+seedAssist);
    //-------------------------//
    FarkleGame Farkle;
    
    //-------------------------//
    pb1.mode(PullUp);
    wait(.01);
    pb1.attach_deasserted(&pb1_pressed);
    pb1.setSampleFrequency();
    
    pb2.mode(PullUp);
    wait(.01);
    pb2.attach_deasserted(&pb2_pressed);
    pb2.setSampleFrequency();
    
    pb3.mode(PullUp);
    wait(.01);
    pb3.attach_deasserted(&pb3_pressed);
    pb3.setSampleFrequency();
   
   //--------------------------//
    
    int turnScore=0;
    
    for( ; ; ){
        switch(currState){
            //----------------------------------------------------------------//
            case(Initial):{
                uLCD.color(WHITE);
                Farkle.startGame();
            //---------------Reading from accelerometer-----------------------//
                while(currState==Initial){
                    double x=0.0l;
                    double y=0.0l;
                    double z=0.0l;
                    if (!acc.isXYZReady()) {
                        wait(0.01);
                    } else {
                        acc.readXYZGravity(&x,&y,&z);
                    }
                    if ((fabs(x)>1.5)||(fabs(y)>1.5)) {
                        input=shake;
                        
                        
                    }
                    //--------------Changing states based on input------------//
                    if (input==buttonA){
                        currState=Initial;
                        input=none;
                        }
                    else if (input==buttonB){
                        Farkle.changeDieArray();
                        Farkle.startGame();
                        currState=Initial;
                        input=none;
                        }
                    else if (input==buttonC){
                        currState=Initial;
                        input=none;
                        }
                    else if (input==shake){
                        currState=Roll;
                        input=none;
                        }
                    else if (input==none){
                        currState=Initial; 
                        input=none;
                        }
                }
                
                continue;
                }
            //----------------------------------------------------------------//    
            case(Roll):{
                int numarray[7]={};//create an array keeping track of how many of each number there are for numbers on die faces
                uLCD.cls();//clear screen
                int tempScore;
                mySpeaker.PlayNote(300.0,0.01,0.005); //make a sound
                
                for(int i=0;i<6;i++){
                    int number=0;
                    if((Farkle.getDieArray())[i].getCurrDieState()==ROLL){//create the numarray based on die face numbers
                        (Farkle.getDieArray())[i].rollDie();
                        (Farkle.getDieArray())[i].drawDie();
                        number=(Farkle.getDieArray())[i].getValue();
                        numarray[number]+=1;
                        }
                    }
                tempScore=Farkle.calcScore(numarray);//use calculate score function to make a tempscore that will be added to turnscore
                if (tempScore==0){
                    turnScore=0;
                    uLCD.color(WHITE);
                    uLCD.text_width(2);
                    uLCD.text_height(2);
                    uLCD.locate(1,6);
                    uLCD.printf("FARKLE");//if score==0 we have a farkle
                }
                else{
                    turnScore+=tempScore;
                    uLCD.color(WHITE);
                    uLCD.text_width(1);
                    uLCD.text_height(1);
                    uLCD.locate(0,11);
                    uLCD.printf("Roll Score: %d", tempScore);
                    uLCD.printf("\nTurn Score: %d", turnScore);
               }
               //------------change states based on input---------------------//
                while(currState==Roll){
                    if (input==buttonC){
                        currState=Initial;
                        input=none;
                        }
                    if (input==buttonA){
                        currState=Display;
                        input=none;
                        }
                }
            
                continue;
            }
            case(Display):{
                uLCD.cls();
                Farkle.setScore(turnScore);//set farkle score data member to turnScore
                Farkle.printScore();//print the score
                for(int i=0;i<6;i++){//reset all die to be rollable if any are currently removed
                    (Farkle.getDieArray())[i].setCurrDieState(ROLL);
                    }
                //----------change state based on inputs----------------------//
                while(currState==Display){
                    if(input==buttonA){
                        turnScore=0;
                        currState=Initial;
                        input=none;
                        }
                    else{
                        currState=Display;
                        
                        }
                    }
                continue;
            }   
        }
    }
   
    
  

}
