#include "mbed.h"
#include "modbus.h"
//DigitalIn button1(USER_BUTTON);
InterruptIn mybtn(USER_BUTTON);
DigitalOut myled(LED1);
RawSerial pc(USBTX, USBRX);
Timer t1,t2,Timer1;
uint8_t id= 40001;
uint16_t offset=1;
uint16_t press=3,release=4,temp=0;
bool pushed = false;

void serial_callback()
{printf("serial call back\n");
    uint8_t frame[6];
    char ch = pc.getc();
    printf("ch = %c \n ",ch);
    
    modbus_init(id);
    modbus_read(offset);
    
    temp=modbus_update( offset, press);
    
     printf("Temp= %f\n",temp);
    if (modbus_parser(ch, frame)) {  
         printf("Modbus Parser\n");
    }
}


void ledON()
{
    myled = 1; //LED ON
    wait(0.2); // 200 ms
     t1.start();
    t2.stop();
    if(t2.read()<0.1)
    { printf("Bouncing\n");}
    else
        {printf("Button released for %.1f seconds.\r\n", t2.read());
        release=t2.read();
    t2.reset();
    }
}

void ledOFF()
{
    myled = 0; //LED OFF
    wait(0.2); // 200 ms
    t1.stop();
    t2.start();   
    if(t1.read()<0.1)
    { printf("Bouncing\n");}
    else
    {
        printf("Button push for %.1f seconds.\r\n", t1.read());
        press=t1.read();
        t1.reset();
    }
}




int main() {
    // setup code
    pc.attach(serial_callback);
    
    // 1. button code
      mybtn.fall(&ledON); // Interrupt occur
    mybtn.rise(&ledOFF);
    // 2. timer code
      
    while(1) {
        
    }
}