#include "mbed.h"
#include "modbus.h"

uint8_t nodeId = 0;
uint16_t regValue[ADDR_RANGE];

enum state {IDLE, RECEPTION, END} protState = IDLE;

int process_buffer(char *buf, uint8_t *frame)
{printf("Modbus buffer\n");
    int status = 0;
    uint8_t sum = 0;
    uint8_t lrc, i;
    char tmpbuf[] = {0, 0, 0};
    
    if (strlen(buf) == 14) {
        for (i = 0; i < 6; i++) {
            tmpbuf[0] = buf[i*2];
            tmpbuf[1] = buf[i*2 + 1]; 
            frame[i] = strtoul(tmpbuf, NULL, 16);
        }
        tmpbuf[0] = buf[12]; tmpbuf[1] = buf[13]; 
        lrc = strtoul(tmpbuf, NULL, 16);
        for (i = 0; i < 6; i++) {
            sum += frame[i];
        }
        if ((sum + lrc) == 0) {
            status = 1;
        }
    }
    
    return status;    
}

void modbus_init(uint8_t id)
{printf("Modbus Initial ID\n");
    nodeId = id;
}

uint16_t modbus_read(uint16_t offset)
{   printf("Modbus Read\n");
    if (offset < ADDR_RANGE) {
        return regValue[offset];
    } 
    return 0xFFFF;
}

uint16_t modbus_update(uint8_t offset, uint16_t val)
{
    uint16_t tmp;
    printf("Modbus Update\n");
    if (offset < ADDR_RANGE) {
        tmp = regValue[offset];
        regValue[offset] = val;
        return tmp;
    } 
    return 0xFFFF;
}

int modbus_parser(char ch, uint8_t *frame)
{
    static char buf[514];
    static int idx = 0;
    static int status = 0;
    
    switch(protState) {
        case IDLE:
            if (ch == ':') {
                protState = RECEPTION;
                idx = 0;
                status = 0;
                printf("IDLE case \n");
            }
            break;
        case RECEPTION:
         printf("Reception case \n");
            if ((ch >= '0') && (ch <= '9')) {
                buf[idx++] = ch; 
                 printf("character length0-9\n");
            } else if ((ch >= 'a') && (ch <= 'f')) {
                buf[idx++] = ch;
            } else if ((ch >= 'A') && (ch <= 'F')) {
                buf[idx++] = ch;
            } else if (ch == '\r') {
                printf("type \r END \n");
                buf[idx] = 0;
                protState = END;
                
            } else {
                protState = IDLE;
            }
            break;
        case END:
            if (ch == '\n') {
                if (process_buffer(buf, frame)) {
                    if ((frame[0] == nodeId) && (frame[1] == FUNC_CODE)) {
                        status = 1;
                        printf("END\n");
                    }
                }
            } 
            protState = IDLE;
            break;
        default:
            protState = IDLE;
    }
    
    return status;
}