#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "Watchdog.h"

EthernetInterface eth;
HTTPClient http;
DigitalOut led1(LED1);
Watchdog wdt;

char recvBuff[1024*40];

void getline(char *line, int size) {
    for(int i=0; i<size; i++) {
        if((line[i] = getchar()) == '\r') {
            line[i] = '\0' ;
            putchar('\n') ;
            break ;
        } else putchar(line[i]) ;
    }
}

unsigned long long atoll(char *instr)
{
  unsigned long long retval;
  //int i;

  retval = 0;
  for (; *instr; instr++) {
    retval = 10*retval + (*instr - '0');
  }
  return retval;
}

void baud(int baudrate) {
    Serial s(USBTX, USBRX);
    s.baud(baudrate);
}

void net_main(void const *av)
{
    int ret ;
    //char substr[10];
    char *found;
    char twitteTag[] = "data-time=";
    char createDate[11] = {0};
    unsigned long long dataTime = 0;
    unsigned long long lastdataTime = 1438467674;
    
    wdt.kick(60);           //init the watchdog for a 60 second timeout
    
    eth.init(); //Use DHCP
    
    printf("HTTPS Client, Starting,...\n\r") ;
    while(1) {
        if(eth.connect() == 0)break ;
        printf("Retry\n") ;
    }

    while(1)
    {
        /*** HTTPS (SSL) ***/
        printf("\nFetching HTTPS\n\r");
        //ret = http.get("https://twitter.com/fsl_mcu.html", recvBuff, sizeof(recvBuff));
        ret = http.get("https://twitter.com/hashtag/tweetforacandy?f=tweets&amp;src=hash", recvBuff, sizeof(recvBuff),HTTP_CLIENT_DEFAULT_TIMEOUT);
        if (!ret) {
            printf("Result: %s\n\r", recvBuff);
              found = strstr(recvBuff, twitteTag);
              snprintf(createDate, sizeof (createDate), found+11);
              dataTime = atoll(createDate);
              printf("The data-time: %s\r\n", createDate);
              
              if (lastdataTime < dataTime)
              {
                  //Give the candy here!!
                  printf("\n\rGiving a candy!!\n\r");
                  led1 = 0;
                  lastdataTime = dataTime;
                  wait(1);
                  led1 = 1;
              }
        } else {
            printf("Error - ret = %d - HTTP return code = %d\n\r", ret, http.getHTTPResponseCode());
        }
        wait(15);
        wdt.kick();         //kick the watchdog before 60 seconds is up
    }
    eth.disconnect();
}

main()
{
    led1 = 1;
    baud (115200);
    
#define STACK_SIZE 20000
        Thread t(net_main, NULL, osPriorityNormal, STACK_SIZE);
    while (true) {
        Thread::wait(2000);
    }
}
