#include "Servo.h"
#include "mbed.h"
#include "RadioIn.h"
#include "Config.h"

void Drive(float m_esq, float m_dir){ // Valores de -1 a 1 em cada motor
saber1.write((m_esq/2)+0.5);
saber2.write((m_esq/2)+0.5);
}

void DriveRC(){
            float trim=0; // Trim para casar o 0 da sabertooth com o PWM do Mbed
            radio.Update();
            saber1.write((radio.chan1+1)/2+trim);
            saber2.write((radio.chan2+1)/2+trim);
}


float ReadRadio(int chan){  // Retorna o valor do canal entre -1 e 1
radio.Update();
if (chan==1){return radio.chan1;}
if (chan==2){return radio.chan2;}
if (chan==3){return radio.chan3;}
else return 0;
}


// Melhor usar o V-Tail Mixer e fazer o mix via hardware
void DriveMixedRC(){            
            radio.Update();
            saber1.write(((radio.chan1+radio.chan2)+1)/2);
            saber2.write(((radio.chan1-radio.chan2)+1)/2);
}

int main()
{
saber1.period_us(5);
saber2.period_us(5);
radio.Init();
while(1){
         DriveMixedRC();
        }
}