#pragma once

//Interrupt-Callback Function
#define RadioIn_RISE_FALL(Ch)\
void Rise##Ch()\
{\
    LastRise[Ch]= Time.read_us();\
}\
void Fall##Ch()\
{\
    int dT= Time.read_us() - LastRise[Ch];\
    if(dT > 900 && dT < 2100)\
         dTime[Ch]= dT;\
}


class RadioIn
{
private:
    InterruptIn ChInt0;           //Interrupt-Handler
    InterruptIn ChInt1;
    InterruptIn ChInt2;
  
    Timer Time;                     //Timer for all 3 Channels
    volatile int LastRise[3];       //Time of the last rise
    volatile int dTime[3];          //Pulse in us [1000...2000]
    
public:
    int RawChannels[3]; //Raw Data [1000...2000]
    
    //Channels (0.0 - 1.0)
    float chan1;     
    float chan2;     
    float chan3;     
    
    //Initialization
    RadioIn();
    void Init();
    
    //Interrupt-Callbacks
    RadioIn_RISE_FALL(0);
    RadioIn_RISE_FALL(1);
    RadioIn_RISE_FALL(2);
    
    //Update Method
    void Update();
};