#include "mbed.h"
#include "RadioIn.h"


//Initialization
RadioIn::RadioIn() :
    ChInt0(InterruptIn(p21)),
    ChInt1(InterruptIn(p22)),
    ChInt2(InterruptIn(p23))
{}
               
void RadioIn::Init()
{
    Time.start();
    
    for(int i= 0; i < 2; i++)
    {
        LastRise[i]= 0;
        dTime[i]= 1000;
    }
    
    ChInt0.mode(PullDown);   ChInt0.rise<RadioIn>(this, &RadioIn::Rise0);     ChInt0.fall<RadioIn>(this, &RadioIn::Fall0);
    ChInt1.mode(PullDown);   ChInt1.rise<RadioIn>(this, &RadioIn::Rise1);     ChInt1.fall<RadioIn>(this, &RadioIn::Fall1);
    ChInt2.mode(PullDown);   ChInt2.rise<RadioIn>(this, &RadioIn::Rise2);     ChInt2.fall<RadioIn>(this, &RadioIn::Fall2);  
    Update();
}

//Update Method
void RadioIn::Update()
{
    for(int i= 0; i<2; i++)
        RawChannels[i]= dTime[i];
    
    //time to float conversion
    chan1= float(dTime[0]-1500) * 0.002;
    if (chan1>1){chan1=1;} if (chan1<-1){chan1=-1;}
    chan2= float(dTime[1]-1500) * 0.002;
    if (chan2>1){chan2=1;} if (chan2<-1){chan2=-1;}
    chan3= float(dTime[2]-1500) * 0.002;
    if (chan3>1){chan3=1;} if (chan3<-1){chan3=-1;}
 }