#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
#include "wave_player.h"
#include "LSM9DS1.h"
#include "PinDetect.h"

DigitalOut myled(LED1);
Serial blue(p28,p27);

uLCD_4DGL uLCD(p13,p14,p11);

SDFileSystem sd(p5, p6, p7, p8, "sd");

LSM9DS1 imu(p9, p10, 0xD6, 0x3C);
Serial pc(USBTX, USBRX);

PinDetect playpause(p23);
Mutex LCD;
Mutex Speaker;
Mutex avgs;
bool play = 0;


AnalogOut DACout(p18);
PwmOut PWMout(p26);
wave_player waver(&DACout,&PWMout);

int avgIMU;
int avgMic;


class microphone
{
public :
    microphone(PinName pin);
    float read();
    operator float ();
private :
    AnalogIn _pin;
};
microphone::microphone (PinName pin):
    _pin(pin)
{
}
float microphone::read()
{
    return _pin.read();
}
inline microphone::operator float ()
{
    return _pin.read();
}
 
microphone mymicrophone(p16);
void TrackSelect()
{
    //Add code here to use the avg to set the next track, or set the next track based on the menu. 
    }
    
void LCDThread(void const *argument)
{
    while(1){
    LCD.lock();
    uLCD.locate(1,1);
    uLCD.printf("Put Song Name Here");
    uLCD.printf("%4D", avgIMU);
    uLCD.printf("%4D", avgMic);
    if(!play)
    {
        //play
        
    uLCD.filled_rectangle(0,118,280,40,BLACK);
    uLCD.triangle(120, 100, 40, 40, 10, 100, 0x0000FF);
    }
    else
    {
        //pause
    uLCD.filled_rectangle(0,118,110,40,WHITE);
    uLCD.filled_rectangle(50,118,100,40,BLACK);
    uLCD.filled_rectangle(180,118,280,40,WHITE);
    }
    LCD.unlock();
    Thread::wait(100);
    }
    
}
void PlayerThread(void const *argument)
{
    Speaker.lock();
    FILE *wave_file;
    wave_file=fopen("/sd/sample.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
    Speaker.unlock();
    Thread::wait(1000);
}
void buttonThread()
{
    //add playpause and skip features here 
    Speaker.lock();
    play=!play;
    myled=play;
    Speaker.unlock();
    Thread::wait(100);
}
void BlueThread(void const *argument)
{
    //add bluetooth control code here 
    while(1)
    {
        if(blue.readable())
        {
            
        }
        }
}
void IMUThread(void const *argument)
{
    while(1){
    avgs.lock();
    //put imu averaging and next track selection code here if that is selected 
    avgMic = int(((abs((mymicrophone - (0.67/3.3)))*500.0)+avgMic)/2);
    imu.readAccel();
    avgIMU=int((((imu.ax+imu.az+imu.ay)/3.0)+avgIMU)/2);
    avgs.unlock();
    Thread::wait(250);
    }
    
}

int main() {
        uLCD.cls();
        uLCD.baudrate(3000000);
        uLCD.background_color(BLACK);
        uLCD.text_width(1);
        uLCD.text_height(1);
        imu.begin();
    if (!imu.begin()) {
        //set fail flag for imu here
    }
    imu.calibrate();
    playpause.mode(PullUp);
    playpause.attach_deasserted(&buttonThread);
    playpause.setSampleFrequency();
    //LCD, Player, button Interrupt, bluetooth, imu+mic
    Thread thread1(LCDThread);
    Thread thread2(PlayerThread);
    Thread thread4(BlueThread);
    Thread thread5(IMUThread);
    while(1) {
        //add some code to show the menu of songs if the mbed pushbutton is pushed here 
        
    }
}
