#include "Uart.h"
#include "Packet.h"
#include "mbed.h"

Serial pc(USBTX, USBRX);

Uart::Uart(Module *m)
{
    pc.baud(230400);
    this->m = m;
    packetscount = 0;
    blub = 0;
}

Uart::~Uart(void)
{
    
}

void Uart::uart_thread() 
{
    //kijken of we data kunnen ontvangen
    if(pc.readable())
    {
        //TOT_SIZE bepalen voor de totale groote van de array 
        uint8_t *totsize = new uint8_t[2];
        totsize[0] = pc.getc();
        totsize[1] = pc.getc();
        int TOT_SIZE = ((totsize[0] << 8) + totsize[1]);
           
        if(TOT_SIZE<7 || TOT_SIZE>50)
        {
            this->flush();
            Packet *p = new Packet(m->getID());
            m->packetWorker(p);
            return;
        }
            
        //DATA packet aanmaken
        uint8_t *data = new uint8_t[TOT_SIZE+2];
            
        //TOT_SIZE
        data[0] = totsize[0];
        data[1] = totsize[1];
            
        //ID
        data[2] = pc.getc();
        data[3] = pc.getc();
            
        //CMD
        data[4] = pc.getc();
            
        //CMD_SIZE
        data[5] = pc.getc();
        data[6] = pc.getc();
            
        //CMD_DATA
        int size = ((data[5] << 8) + data[6]);
        if(size+7 != TOT_SIZE)
        {
            this->flush();
            Packet *p = new Packet(m->getID());
            m->packetWorker(p);
            return;
        }
        for (int i = 7; i < size+7; i++)
        {
            data[i] = pc.getc();
        }
        //RESERVED
        data[size+7] = pc.getc();
        data[size+8] = pc.getc();
            
        this->flush();
        Packet *p = new Packet(m->getID(),data,TOT_SIZE+2);
        m->packetWorker(p);
            
        delete [] totsize;
        delete [] data;
            
    }   
    //kijken of we data kunnen versturen
    if(packetscount > 0)
    {
        for(int i = 0; i < packetscount; i++)
        {
            //pc.printf("PACKET: ");
            Packet *p = packets[i];
            
            //TOT_SIZE bytes
            pc.putc((p->getTOT_SIZE() >> 8) & 255);
            pc.putc((p->getTOT_SIZE() & 255));
            
            //ID bytes
            pc.putc(p->getID()[0]);
            pc.putc(p->getID()[1]);
            
            //CMD byte
            pc.putc(p->getCMD());
            
            //CMD_SIZE bytes
            pc.putc((p->getCMD_SIZE()>>8)& 255);
            pc.putc(p->getCMD_SIZE() & 255);
            
            //CMD_DATA            
            for (int j = 0; j < p->getCMD_SIZE(); j++)
            {
                pc.putc(p->getCMD_DATA()[j]);
            }
            
            //RESERVED bytes
            pc.putc(p->getRESERVED()[0]);
            pc.putc(p->getRESERVED()[1]);
            
            //pc.printf("PACKET: %d \n",this->blub++);
            delete p;
            //pc.printf("\n");   
        }
        packetscount = 0;
    }       
}
void Uart::send(Packet *p)
{
    //packet toevoegen aan de buffer
    if(packetscount<2)
    {
        packets[packetscount] = p;
        packetscount++;
    }
    else
    {
        //laten weten aan module dat de buffer vol zit, zodat een lampje gaat branden
    }
}

void Uart::flush(void)
{
    while(pc.readable())
    {
        pc.getc();
    }
    return;
}