#include "mbed.h"
#include "Module.h"
#include "rtos.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

Module *m;

void uartThread(void const *args) 
{
    while(1)
    {
        led2 =! led2;
        m->getUart()->uart_thread();
        wait(0.01);
    }
}

void meet(void const *)
{
    led3 =! led3;
    m->meting_thread();  
}

int main() 
{
    m = new Module();
    Thread uartthread(uartThread);
    
    m->mainLoop();
    
    wait(4);
    RtosTimer meetTimer(meet);
    meetTimer.start(4);
    
    while(1)
    {
        led1 =! led1;
        wait(0.5);
    }
}
