#ifndef PACKET
#define PACKET

#include "mbed.h"
#include "Measurement.h"



//------PACKET PROTOCOL COMMMANDS------\\
//      COMMAND             BYTE
#define PACKET_ACK                 0x00
#define PACKET_NACK                0x01
#define PACKET_ERROR               0x02
#define PACKET_ALIVE               0x10
#define PACKET_INIT                0x11
#define PACKET_ENABLE_DATA         0x20
#define PACKET_DATA                0x21
#define PACKET_CHANGE_IP           0x30
#define PACKET_REMOVE_IP           0x31
#define PACKET_GET_IP              0x32
#define PACKET_GET_IP_REPLY        0x33
#define PACKET_VERSION             0x34
#define PACKET_VERSION_REPLY       0x35
#define PACKET_SET_PACKAGE_SIZE    0x36
#define PACKET_GET_SETTINGS        0x37
#define PACKET_GET_SETTINGS_REPLY  0x38
#define PACKET_SET_ID              0x39
#define PACKET_TEST_MODE           0x40
#define PACKET_LED_TEST_MODE       0x41






class Packet
{
private:
    uint8_t CMD;
    int CMD_SIZE;
    int TOT_SIZE;
    int nBytesFilled;//in case it is a measurement packet this counter represents the number of packets that are currently in the packet
    
    uint8_t *ID;
    uint8_t *CMD_DATA;
    uint8_t *RESERVED;


public:
    //Constructor & Destructor
    Packet(uint8_t ID[2]); //CREATES A ERROR packet
    Packet(uint8_t ID[2],uint8_t* packet,int length);
    Packet(uint8_t ID[2],uint8_t CMD,uint8_t RESERVED[2]);
    Packet(uint8_t ID[2],uint8_t CMD,uint8_t* packetdata,int packetlength,uint8_t RESERVED[2]);
    Packet(uint8_t ID[2],unsigned int firstSampleNumber,uint8_t nSamples,uint8_t sampleRate ,int activeChannels,int nActiveChannels,uint8_t RESERVED[2]);
    ~Packet(void);

    //GETTERS
    int getTOT_SIZE(void);
    uint8_t* getID(void);
    uint8_t getCMD(void);
    int getCMD_SIZE(void);
    uint8_t* getCMD_DATA(void);
    uint8_t* getRESERVED(void);
    int getBytesFilled(void);

    //SETTERS
    void setID(uint8_t ID[2]);
    void setCMD(uint8_t CMD);
    void setDATA(uint8_t* packetdata,int length);
    void setRESERVED(uint8_t RESERVED[2]);
    bool addMeasurement(Measurement *m);
};

#endif