#ifndef MODULE_H
#define MODULE_H

#include "Uart.h"
#include "Packet.h"
#include "DAQ.h"
#include "rtos.h"

class Uart;

class Module
{
private:
    Uart *uart;
    DAQ *daq;
    
    //local variables
    uint8_t ID[2];
    uint8_t IP[4];
    uint8_t version[2];
    
    bool enableData;
    uint8_t packageSize;
    unsigned int sampleNumber;
    uint8_t sampleRate;
    Packet *dataPacket;  
    
    //methodes om te sturen via uart/wifi
    bool wifiEnabled;
    void sendPacket(Packet *p);
    void sendAlivePacket();
    void creatDataPacket();
    
    //hulpmethodes voor het verwerken van pakketten.
    void HandleInit(Packet *p);
    void HandleEnableData(Packet *p);
    void HandleChangeIP(Packet *p);
    void HandleSetPackageSize(Packet *p);
    void IpReply();
    void VersionReply();
    void LedTest(uint8_t ledInfo);
    void SettingsReply();
    
public:
    Module(void);
    ~Module(void);
    
    //main functie
    void mainLoop(void);
    //meting thread
    void meting_thread();
    
    
    
    //GETTERS
    Uart* getUart(void);
    uint8_t* getID(void);
    uint8_t* getIP(void);
    uint8_t* getVersion(void);
    bool dataEnabled(void);
    uint8_t getPackageSize(void);
    unsigned int getSampleNumber(void);
    uint8_t getSampleRate(void);
    
    //SETTERS
    void setID(uint8_t ID[2]);
    void setIP(uint8_t IP[4]);
    void removeIP();
    void setVersion(uint8_t version[2]);
    void EnableData(void);
    void DisableData(void);
    void setPackageSize(uint8_t packageSize);
    void setSampleNumber(unsigned int sampleNumber);
    void setSampleRate(uint8_t samleRate);
    
    
    //--PACKET WORKER
    void packetWorker(Packet *p);
    void Acknowledge(uint8_t RESERVED[2]);
    void Acknowledge();
};
#endif