#include "DAQ.h"
#include "mbed.h"

//Constructor en Destructor
DAQ::DAQ(void)
{
    this->channels = new Channel*[16];
    this->multiplexer = new Multiplexer();
    this->amplifier = new Amplifier();
    this->adc = new ADC();
    this->initialized = false;
    
    for (int i = 0; i < 16; i++)
    {       
        channels[i] = new Channel();
    }
}
DAQ::~DAQ(void)
{
    for (int i = 0; i < 16; i++)
    {       
        delete channels[i];
    }
    delete [] channels;
    delete multiplexer;
    delete amplifier;
    delete adc;
}

//GETTERS
Measurement* DAQ::measure(void)
{
    Measurement *measurement = new Measurement();
    for (int i = 0; i < 16; i++)
    {
        if(channels[i]->Enabled())
        {
            //amplifier op de juiste waarde zetten
            amplifier->setAmplification(channels[i]->getAmplification());
            wait_us(1);

            //multiplexer aanzetten
            multiplexer->setChannel(i);
            multiplexer->Enable();
            wait_us(1);

            //ADC uitlezen
            measurement->Enable(i);
            measurement->setPunt(i,adc->measure());
            wait_us(1);

            //multiplexer uitzetten
            multiplexer->Disable();
        }
        else
        {
            measurement->setPunt(i,0);
        }
    }
    return measurement;
}
int DAQ::getChannelGain(int channel)
{
    if(channel>=0 && channel<16)
    {
        return(channels[channel]->getAmplification());
    }
    return -1;
}
bool DAQ::ChannelEnabled(int channel)
{
    if(channel>=0 && channel<16)
    {
        return(channels[channel]->Enabled());
    }
    return false;
}
bool DAQ::ChannelsDisabled()
{
    for(int i=0;i<16;i++)
    {
        if(channels[i]->Enabled())
        {
            return false;
        }
    }
    return true;
}
bool DAQ::Initialized(void)
{
    return(initialized);
}

//SETTERS
void DAQ::setChannelGain(int channel,int gain)
{
    if(channel>=0 && channel<16)
    {
        channels[channel]->setAmplification(gain);
    }
}
void DAQ::enableChannel(int channel)
{
    if(channel>=0 && channel<16)
    {
        channels[channel]->Enable();
    }
}
void DAQ::disableChannel(int channel)
{
    if(channel>=0 && channel<16)
    {
        channels[channel]->Disable();
    }
}
void DAQ::setInitialized(bool init)
{
    initialized = init;
}