#include "Multiplexer.h"
#include "mbed.h"

DigitalOut sync(p21);
DigitalOut sclk_mux(p23);
DigitalOut din(p22);

#define ENABLE 7
#define CSA 6
#define CSB 5
#define UNUSED_BIT 4
#define A3 3
#define A2 2
#define A1 1
#define A0 0

//Constructor & Destructor
Multiplexer::Multiplexer(void)
{
    sclk_mux = 0;
    sync = 1;
    din = 0;

    enable = false;
    channel = 0;
}
Multiplexer::~Multiplexer(void)
{
}

//GETTERS
bool Multiplexer::Enabled(void)
{
    return(enable);
}
int Multiplexer::getChannel(void)
{
    return(channel);
}

//SETTERS
void Multiplexer::Enable(void)
{
    enable = true;
    Update();
}
void Multiplexer::Disable(void)
{
    enable = false;
    Update();
}
void Multiplexer::setChannel(int newChannel)
{
    if(newChannel>=0 && newChannel<16)
    {
        channel = newChannel;
        Update();
    }
}

//updater
void Multiplexer::Update(void)
{

    //onze data opmaken
    char data = 0;
    data |= !enable << ENABLE;
    data |= 0 << CSA;
    data |= 0 << CSB;
    data |= 1 << UNUSED_BIT;
    data |= channel;

    //Timing diagrama uitvoeren
    sclk_mux = 1;
    wait_us(1);

    sclk_mux = 0;
    wait_us(1);

    sync = 0;
    for (int i = 7; i >= 0; i--)
    {
        sclk_mux = 1;
        din = (data >> i) & 1;
        wait_us(1);

        sclk_mux = 0; 
        wait_us(1);
    }

    //terug standaard waarden
    sclk_mux = 0;
    sync = 1;
    din = 0;
}