#include "Measurement.h"

Measurement::Measurement(void)
{
    this->punten = new int[16];
    this->puntEnabled = new bool[16];
    
    for (int i = 0; i < 16; i++)
    {
        this->punten[i] = 0;
        this->puntEnabled[i] = false;
    }
}

Measurement::~Measurement(void)
{
    delete [] punten;
    delete [] puntEnabled;
}

//GETTERS
int Measurement::getPunt(int channel)
{
    if(channel>=0 && channel<16)
    {
        return(this->punten[channel]);
    }
    return(-1);
}
bool Measurement::Enabled(int channel)
{
    if(channel>=0 && channel<16)
    {
        return(this->puntEnabled[channel]);
    }
    return(false);
}

//SETTERS
void Measurement::setPunt(int channel,int punt)
{
    if(channel>=0 && channel<16)
    {
        this->punten[channel] = punt;
    }
}
void Measurement::Enable(int channel)
{
    if(channel>=0 && channel<16)
    {
        this->puntEnabled[channel] = true;
    }
}
void Measurement::Disable(int channel)
{
    if(channel>=0 && channel<16)
    {
        this->puntEnabled[channel] = false;
    }
}