#include "Amplifier.h"
#include "mbed.h"

//amplifier1 (AD8253)
DigitalOut a1a1(p19);
DigitalOut a1a0(p20);

//amplifier2 (AD8250)
DigitalOut a2a1(p17);
DigitalOut a2a0(p18);

//Constructor & Destructor
Amplifier::Amplifier(void)
{
    enable = false;
    setAmplification(1);
}
Amplifier::~Amplifier(void)
{
}

//GETTERS
bool Amplifier::Enabled(void)
{
    return(enable);
}
int Amplifier::getAmplification(void)
{
    return(amplification);
}

//SETTERS
void Amplifier::Enable(void)
{
    enable = true;
}
void Amplifier::Disable(void)
{
    enable = false;
}
void Amplifier::setAmplification(int newAmplification)
{
    if(newAmplification==1 || newAmplification==2 || newAmplification==5 || newAmplification==10 || newAmplification==20 || newAmplification==50 || newAmplification==100 || newAmplification==200 || newAmplification==500 || newAmplification==1000 || newAmplification==2000 || newAmplification==5000 || newAmplification==10000)
    {
        amplification = newAmplification;

        switch (newAmplification)
        {
        case 1: 
            a1a1 = 0;
            a1a0 = 0;
            
            a2a1 = 0;
            a2a0 = 0;
            break;
        case 2:
            a1a1 = 0;
            a1a0 = 0;
            
            a2a1 = 0;
            a2a0 = 1;
            break;
        case 5: 
            a1a1 = 0;
            a1a0 = 0;
            
            a2a1 = 1;
            a2a0 = 0;
            break;
        case 10:
            a1a1 = 0;
            a1a0 = 1;
            
            a2a1 = 0;
            a2a0 = 0;
            break;
        case 20: 
            a1a1 = 0;
            a1a0 = 1;
            
            a2a1 = 0;
            a2a0 = 1;
            break;
        case 50:
            a1a1 = 0;
            a1a0 = 1;
            
            a2a1 = 1;
            a2a0 = 0;
            break;
        case 100: 
            a1a1 = 1;
            a1a0 = 0;
            
            a2a1 = 0;
            a2a0 = 0;
            break;
        case 200:
            a1a1 = 1;
            a1a0 = 0;
            
            a2a1 = 0;
            a2a0 = 1;
            break;
        case 500: 
            a1a1 = 1;
            a1a0 = 0;
            
            a2a1 = 1;
            a2a0 = 0;
            break;
        case 1000:
            a1a1 = 1;
            a1a0 = 1;
            
            a2a1 = 0;
            a2a0 = 0;
            break;
        case 2000: 
            a1a1 = 1;
            a1a0 = 1;
            
            a2a1 = 0;
            a2a0 = 1;
            break;
        case 5000:
            a1a1 = 1;
            a1a0 = 1;
            
            a2a1 = 1;
            a2a0 = 0;
            break;
        case 10000:
            a1a1 = 1;
            a1a0 = 1;
            
            a2a1 = 1;
            a2a0 = 1;
            break;
        default:
            a1a1 = 0;
            a1a0 = 0;
            
            a2a1 = 0;
            a2a0 = 0;
            break;
        }
    }
}
